/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;

public final class OrderImports
extends Recipe {
    @Option(displayName="Remove unused", description="Remove unnecessary imports.", required=false)
    @Nullable
    private final Boolean removeUnused;

    public String getDisplayName() {
        return "Order imports";
    }

    public String getDescription() {
        return "Groups and orders import statements. If a [style has been defined](https://docs.openrewrite.org/concepts-explanations/styles), this recipe will order the imports according to that style. If no style is detected, this recipe will default to ordering imports in the same way that IntelliJ IDEA does.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
                Optional sourceSet = ((J.CompilationUnit)cu).getMarkers().findFirst(JavaSourceSet.class);
                List<JavaType.FullyQualified> classpath = Collections.emptyList();
                if (sourceSet.isPresent()) {
                    classpath = ((JavaSourceSet)sourceSet.get()).getClasspath();
                }
                List<JRightPadded<J.Import>> orderedImports = layoutStyle.orderImports(((J.CompilationUnit)cu).getPadding().getImports(), classpath);
                boolean changed = false;
                if (orderedImports.size() != ((J.CompilationUnit)cu).getImports().size()) {
                    cu = ((J.CompilationUnit)cu).getPadding().withImports((List)orderedImports);
                    changed = true;
                } else {
                    for (int i = 0; i < orderedImports.size(); ++i) {
                        if (orderedImports.get(i) == ((J.CompilationUnit)cu).getPadding().getImports().get(i)) continue;
                        cu = ((J.CompilationUnit)cu).getPadding().withImports((List)orderedImports);
                        changed = true;
                        break;
                    }
                }
                if (Boolean.TRUE.equals(OrderImports.this.removeUnused)) {
                    this.doAfterVisit(new RemoveUnusedImports().getVisitor());
                } else if (changed) {
                    this.doAfterVisit(new FormatFirstClassPrefix());
                }
                return cu;
            }
        };
    }

    @Generated
    public OrderImports(@Nullable Boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    @Nullable
    @Generated
    public Boolean getRemoveUnused() {
        return this.removeUnused;
    }

    @NonNull
    @Generated
    public String toString() {
        return "OrderImports(removeUnused=" + this.getRemoveUnused() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderImports)) {
            return false;
        }
        OrderImports other = (OrderImports)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$removeUnused = this.getRemoveUnused();
        Boolean other$removeUnused = other.getRemoveUnused();
        return !(this$removeUnused == null ? other$removeUnused != null : !((Object)this$removeUnused).equals(other$removeUnused));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof OrderImports;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $removeUnused = this.getRemoveUnused();
        result = result * 59 + ($removeUnused == null ? 43 : ((Object)$removeUnused).hashCode());
        return result;
    }
}

