/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class UseTreeRandomId
extends Recipe {
    public String getDisplayName() {
        return "Use `Tree.randomId()` in LST constructors";
    }

    public String getDescription() {
        return "Replaces occurrences of `UUID.randomUUID()` with `Tree.randomId()` when passed as an argument to a constructor call for LST elements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TypeMatcher treeMatcher = new TypeMatcher("org.openrewrite.Tree", true);
        final MethodMatcher randomUUIDMatcher = new MethodMatcher("java.util.UUID randomUUID()");
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.Tree", true), new UsesMethod(randomUUIDMatcher)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J n = super.visitNewClass(newClass, ctx);
                if (!treeMatcher.matches(((J.NewClass)n).getType())) {
                    return n;
                }
                return ((J.NewClass)n).withArguments(ListUtils.mapFirst(((J.NewClass)n).getArguments(), this::maybeReplace));
            }

            private Expression maybeReplace(Expression expression) {
                if (!randomUUIDMatcher.matches(expression)) {
                    return expression;
                }
                this.maybeAddImport("org.openrewrite.Tree");
                this.maybeRemoveImport("java.util.UUID");
                J.MethodInvocation mi = (J.MethodInvocation)expression;
                JavaType.ShallowClass classType = JavaType.ShallowClass.build("org.openrewrite.Tree");
                JavaType.Method methodType = mi.getMethodType().withName("randomId").withDeclaringType(classType);
                mi = mi.withName(mi.getName().withSimpleName("randomId").withType(methodType));
                if (mi.getSelect() instanceof J.Identifier) {
                    return mi.withSelect(((J.Identifier)mi.getSelect()).withSimpleName("Tree").withType(classType));
                }
                return mi.withSelect(new J.Identifier(Tree.randomId(), mi.getPrefix(), mi.getMarkers(), Collections.emptyList(), "Tree", classType, null));
            }
        });
    }

    @Generated
    public UseTreeRandomId() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseTreeRandomId()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseTreeRandomId)) {
            return false;
        }
        UseTreeRandomId other = (UseTreeRandomId)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseTreeRandomId;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

