/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class ChangeMethodTargetToStatic
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations. The original method call may or may not be a static method invocation.", example="com.google.common.collect.ImmutableSet of(..)")
    private final String methodPattern;
    @Option(displayName="Fully-qualified target type name", description="A fully-qualified class name of the type upon which the static method is defined.", example="java.util.Set")
    private final String fullyQualifiedTargetTypeName;
    @Option(displayName="Return type after change", description="Sometimes changing the target type also changes the return type. In the Guava example, changing from `ImmutableSet#of(..)` to `Set#of(..)` widens the return type from Guava's `ImmutableSet` to just `java.util.Set`.", example="java.util.Set", required=false)
    @Nullable
    private final String returnType;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;
    @Option(displayName="Match unknown types", description="When enabled, include method invocations which appear to match if full type information is missing. Using matchUnknownTypes can improve recipe resiliency for an AST with missing type information, but also increases the risk of false-positive matches on unrelated method invocations.", required=false)
    @Nullable
    private final Boolean matchUnknownTypes;

    public ChangeMethodTargetToStatic(String methodPattern, String fullyQualifiedTargetTypeName, @Nullable String returnType, @Nullable Boolean matchOverrides) {
        this(methodPattern, fullyQualifiedTargetTypeName, returnType, matchOverrides, false);
    }

    @JsonCreator
    public ChangeMethodTargetToStatic(String methodPattern, String fullyQualifiedTargetTypeName, @Nullable String returnType, @Nullable Boolean matchOverrides, @Nullable Boolean matchUnknownTypes) {
        this.methodPattern = methodPattern;
        this.fullyQualifiedTargetTypeName = fullyQualifiedTargetTypeName;
        this.returnType = returnType;
        this.matchOverrides = matchOverrides;
        this.matchUnknownTypes = matchUnknownTypes;
    }

    public String getDisplayName() {
        return "Change method target to static";
    }

    public String getDescription() {
        return "Change method invocations to static method calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        boolean matchUnknown = Boolean.TRUE.equals(this.matchUnknownTypes);
        ChangeMethodTargetToStaticVisitor visitor = new ChangeMethodTargetToStaticVisitor(new MethodMatcher(this.methodPattern, this.matchOverrides), matchUnknown);
        return matchUnknown ? visitor : Preconditions.check(new UsesMethod(this.methodPattern, this.matchOverrides), (TreeVisitor)visitor);
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getFullyQualifiedTargetTypeName() {
        return this.fullyQualifiedTargetTypeName;
    }

    @Nullable
    @Generated
    public String getReturnType() {
        return this.returnType;
    }

    @Nullable
    @Generated
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @Nullable
    @Generated
    public Boolean getMatchUnknownTypes() {
        return this.matchUnknownTypes;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeMethodTargetToStatic(methodPattern=" + this.getMethodPattern() + ", fullyQualifiedTargetTypeName=" + this.getFullyQualifiedTargetTypeName() + ", returnType=" + this.getReturnType() + ", matchOverrides=" + this.getMatchOverrides() + ", matchUnknownTypes=" + this.getMatchUnknownTypes() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodTargetToStatic)) {
            return false;
        }
        ChangeMethodTargetToStatic other = (ChangeMethodTargetToStatic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        Boolean this$matchUnknownTypes = this.getMatchUnknownTypes();
        Boolean other$matchUnknownTypes = other.getMatchUnknownTypes();
        if (this$matchUnknownTypes == null ? other$matchUnknownTypes != null : !((Object)this$matchUnknownTypes).equals(other$matchUnknownTypes)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$fullyQualifiedTargetTypeName = this.getFullyQualifiedTargetTypeName();
        String other$fullyQualifiedTargetTypeName = other.getFullyQualifiedTargetTypeName();
        if (this$fullyQualifiedTargetTypeName == null ? other$fullyQualifiedTargetTypeName != null : !this$fullyQualifiedTargetTypeName.equals(other$fullyQualifiedTargetTypeName)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        return !(this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodTargetToStatic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        Boolean $matchUnknownTypes = this.getMatchUnknownTypes();
        result = result * 59 + ($matchUnknownTypes == null ? 43 : ((Object)$matchUnknownTypes).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $fullyQualifiedTargetTypeName = this.getFullyQualifiedTargetTypeName();
        result = result * 59 + ($fullyQualifiedTargetTypeName == null ? 43 : $fullyQualifiedTargetTypeName.hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        return result;
    }

    private class ChangeMethodTargetToStaticVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final boolean matchUnknownTypes;
        private final JavaType.FullyQualified classType;

        public ChangeMethodTargetToStaticVisitor(MethodMatcher methodMatcher, boolean matchUnknownTypes) {
            this.classType = JavaType.ShallowClass.build(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName);
            this.methodMatcher = methodMatcher;
            this.matchUnknownTypes = matchUnknownTypes;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            boolean calledOnTargetType;
            J m = super.visitMethodInvocation(method, ctx);
            Expression select = method.getSelect();
            boolean isStatic = method.getMethodType() != null && method.getMethodType().hasFlags(Flag.Static);
            boolean isSameReceiverType = select != null && TypeUtils.isOfClassType(select.getType(), ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName);
            boolean bl = calledOnTargetType = select instanceof J.Identifier && ((J.Identifier)select).getFieldType() == null;
            if (!(isStatic && isSameReceiverType && calledOnTargetType || !this.methodMatcher.matches(method, this.matchUnknownTypes))) {
                JavaType.Method transformedType = null;
                if (method.getMethodType() != null) {
                    this.maybeRemoveImport(method.getMethodType().getDeclaringType());
                    transformedType = method.getMethodType().withDeclaringType(this.classType);
                    if (!method.getMethodType().hasFlags(Flag.Static)) {
                        LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getMethodType().getFlags());
                        flags.add(Flag.Static);
                        transformedType = transformedType.withFlags(flags);
                    }
                    if (ChangeMethodTargetToStatic.this.returnType != null) {
                        JavaType.ShallowClass returnTypeType = JavaType.ShallowClass.build(ChangeMethodTargetToStatic.this.returnType);
                        transformedType = transformedType.withReturnType(returnTypeType);
                    }
                }
                if (((J.MethodInvocation)m).getSelect() == null) {
                    this.maybeAddImport(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName, ((J.MethodInvocation)m).getSimpleName(), !this.matchUnknownTypes);
                } else {
                    this.maybeAddImport(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName, !this.matchUnknownTypes);
                    m = method.withSelect(new J.Identifier(Tree.randomId(), select == null ? Space.EMPTY : select.getPrefix(), Markers.EMPTY, Collections.emptyList(), this.classType.getClassName(), this.classType, null));
                }
                m = ((J.MethodInvocation)m).withMethodType(transformedType).withName(((J.MethodInvocation)m).getName().withType(transformedType));
            }
            return m;
        }
    }
}

