/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AddOrUpdateAnnotationAttribute
extends Recipe {
    @Option(displayName="Annotation Type", description="The fully qualified name of the annotation.", example="org.junit.Test")
    private final String annotationType;
    @Option(displayName="Attribute name", description="The name of attribute to change. If omitted defaults to 'value'.", required=false, example="timeout")
    @Nullable
    private final String attributeName;
    @Option(displayName="Attribute value", description="The value to set the attribute to. Set to `null` to remove the attribute.", example="500")
    @Nullable
    private final String attributeValue;
    @Option(displayName="Add Only", description="When set to `true` will not change existing annotation attribute values.")
    @Nullable
    private final Boolean addOnly;

    public String getDisplayName() {
        return "Add or update annotation attribute";
    }

    public String getDescription() {
        return "Some annotations accept arguments. This recipe sets an existing argument to the specified value, or adds the argument if it is not already set.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.annotationType, false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation a, ExecutionContext ctx) {
                if (!TypeUtils.isOfClassType(a.getType(), AddOrUpdateAnnotationAttribute.this.annotationType)) {
                    return a;
                }
                String newAttributeValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, AddOrUpdateAnnotationAttribute.this.attributeValue, a);
                List<Expression> currentArgs = a.getArguments();
                if (currentArgs == null || currentArgs.isEmpty()) {
                    if (newAttributeValue == null) {
                        return a;
                    }
                    if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                        return (J.Annotation)JavaTemplate.builder("#{}").contextSensitive().build().apply(this.getCursor(), a.getCoordinates().replaceArguments(), newAttributeValue);
                    }
                    return (J.Annotation)JavaTemplate.builder("#{} = #{}").contextSensitive().build().apply(this.getCursor(), a.getCoordinates().replaceArguments(), AddOrUpdateAnnotationAttribute.this.attributeName, newAttributeValue);
                }
                AtomicBoolean foundAttributeWithDesiredValue = new AtomicBoolean(false);
                J.Annotation finalA = a;
                List newArgs = ListUtils.map(currentArgs, it -> {
                    if (it instanceof J.Assignment) {
                        J.Assignment as = (J.Assignment)it;
                        J.Identifier var = (J.Identifier)as.getVariable();
                        if (AddOrUpdateAnnotationAttribute.this.attributeName == null || !AddOrUpdateAnnotationAttribute.this.attributeName.equals(var.getSimpleName())) {
                            return it;
                        }
                        J.Literal value = (J.Literal)as.getAssignment();
                        if (newAttributeValue == null) {
                            return null;
                        }
                        if (newAttributeValue.equals(value.getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                            foundAttributeWithDesiredValue.set(true);
                            return it;
                        }
                        return as.withAssignment(value.withValue(newAttributeValue).withValueSource(newAttributeValue));
                    }
                    if (it instanceof J.Literal) {
                        if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                            if (newAttributeValue == null) {
                                return null;
                            }
                            J.Literal value = (J.Literal)it;
                            if (newAttributeValue.equals(value.getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                foundAttributeWithDesiredValue.set(true);
                                return it;
                            }
                            return ((J.Literal)it).withValue(newAttributeValue).withValueSource(newAttributeValue);
                        }
                        return ((J.Annotation)JavaTemplate.builder("value = #{}").contextSensitive().build().apply(this.getCursor(), finalA.getCoordinates().replaceArguments(), it)).getArguments().get(0);
                    }
                    return it;
                });
                if (foundAttributeWithDesiredValue.get() || newArgs != currentArgs) {
                    return a.withArguments(newArgs);
                }
                String effectiveName = AddOrUpdateAnnotationAttribute.this.attributeName == null ? "value" : AddOrUpdateAnnotationAttribute.this.attributeName;
                J.Assignment as = (J.Assignment)((J.Annotation)JavaTemplate.builder("#{} = #{}").contextSensitive().build().apply(this.getCursor(), a.getCoordinates().replaceArguments(), effectiveName, newAttributeValue)).getArguments().get(0);
                List newArguments = ListUtils.concat((Object)as, a.getArguments());
                a = a.withArguments(newArguments);
                a = this.autoFormat(a, ctx);
                return a;
            }
        });
    }

    @Nullable
    private static String maybeQuoteStringArgument(@Nullable String attributeName, @Nullable String attributeValue, J.Annotation annotation) {
        if (attributeValue != null && AddOrUpdateAnnotationAttribute.attributeIsString(attributeName, annotation)) {
            return "\"" + attributeValue + "\"";
        }
        return attributeValue;
    }

    private static boolean attributeIsString(@Nullable String attributeName, J.Annotation annotation) {
        String actualAttributeName = attributeName == null ? "value" : attributeName;
        JavaType.Class annotationType = (JavaType.Class)annotation.getType();
        if (annotationType != null) {
            for (JavaType.Method m : annotationType.getMethods()) {
                if (!m.getName().equals(actualAttributeName)) continue;
                return TypeUtils.isOfClassType(m.getReturnType(), "java.lang.String");
            }
        }
        return false;
    }

    @Generated
    public AddOrUpdateAnnotationAttribute(String annotationType, @Nullable String attributeName, @Nullable String attributeValue, @Nullable Boolean addOnly) {
        this.annotationType = annotationType;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.addOnly = addOnly;
    }

    @Generated
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Nullable
    @Generated
    public String getAttributeName() {
        return this.attributeName;
    }

    @Nullable
    @Generated
    public String getAttributeValue() {
        return this.attributeValue;
    }

    @Nullable
    @Generated
    public Boolean getAddOnly() {
        return this.addOnly;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddOrUpdateAnnotationAttribute(annotationType=" + this.getAnnotationType() + ", attributeName=" + this.getAttributeName() + ", attributeValue=" + this.getAttributeValue() + ", addOnly=" + this.getAddOnly() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOrUpdateAnnotationAttribute)) {
            return false;
        }
        AddOrUpdateAnnotationAttribute other = (AddOrUpdateAnnotationAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addOnly = this.getAddOnly();
        Boolean other$addOnly = other.getAddOnly();
        if (this$addOnly == null ? other$addOnly != null : !((Object)this$addOnly).equals(other$addOnly)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$attributeValue = this.getAttributeValue();
        String other$attributeValue = other.getAttributeValue();
        return !(this$attributeValue == null ? other$attributeValue != null : !this$attributeValue.equals(other$attributeValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddOrUpdateAnnotationAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addOnly = this.getAddOnly();
        result = result * 59 + ($addOnly == null ? 43 : ((Object)$addOnly).hashCode());
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $attributeValue = this.getAttributeValue();
        result = result * 59 + ($attributeValue == null ? 43 : $attributeValue.hashCode());
        return result;
    }
}

