/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class RemoveAnnotationAttribute
extends Recipe {
    @Option(displayName="Annotation Type", description="The fully qualified name of the annotation.", example="org.junit.Test")
    private final String annotationType;
    @Option(displayName="Attribute name", description="The name of attribute to remove.", example="timeout")
    private final String attributeName;

    public String getDisplayName() {
        return "Remove annotation attribute";
    }

    public String getInstanceNameSuffix() {
        String shortType = this.annotationType.substring(this.annotationType.lastIndexOf(46) + 1);
        return String.format("`@%s(%s)`", shortType, this.attributeName);
    }

    public String getDescription() {
        return "Some annotations accept arguments. This recipe removes an existing attribute.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.annotationType, false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher annotationMatcher;
            {
                this.annotationMatcher = new AnnotationMatcher(RemoveAnnotationAttribute.this.annotationType);
            }

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J a = super.visitAnnotation(annotation, ctx);
                if (!this.annotationMatcher.matches((J.Annotation)a)) {
                    return a;
                }
                AtomicBoolean didPassFirstAttribute = new AtomicBoolean(false);
                AtomicBoolean shouldTrimNextPrefix = new AtomicBoolean(false);
                return ((J.Annotation)a).withArguments(ListUtils.map(((J.Annotation)a).getArguments(), arg -> {
                    try {
                        if (arg instanceof J.Assignment) {
                            J.Assignment assignment = (J.Assignment)arg;
                            J.Identifier variable = (J.Identifier)assignment.getVariable();
                            if (RemoveAnnotationAttribute.this.attributeName.equals(variable.getSimpleName())) {
                                if (!didPassFirstAttribute.get()) {
                                    shouldTrimNextPrefix.set(true);
                                }
                                Expression expression = null;
                                return expression;
                            }
                        } else if (RemoveAnnotationAttribute.this.attributeName.equals("value")) {
                            if (!didPassFirstAttribute.get()) {
                                shouldTrimNextPrefix.set(true);
                            }
                            Expression expression = null;
                            return expression;
                        }
                        if (shouldTrimNextPrefix.get()) {
                            shouldTrimNextPrefix.set(false);
                            Expression expression = (Expression)arg.withPrefix(arg.getPrefix().withWhitespace(""));
                            return expression;
                        }
                    }
                    finally {
                        didPassFirstAttribute.set(true);
                    }
                    return arg;
                }));
            }
        });
    }

    public RemoveAnnotationAttribute(String annotationType, String attributeName) {
        this.annotationType = annotationType;
        this.attributeName = attributeName;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @NonNull
    public String toString() {
        return "RemoveAnnotationAttribute(annotationType=" + this.getAnnotationType() + ", attributeName=" + this.getAttributeName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveAnnotationAttribute)) {
            return false;
        }
        RemoveAnnotationAttribute other = (RemoveAnnotationAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        return !(this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveAnnotationAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        return result;
    }
}

