/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.NoWhitespaceBeforeStyle;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class NoWhitespaceBefore
extends Recipe {
    public String getDisplayName() {
        return "No whitespace before";
    }

    public String getDescription() {
        return "Removes unnecessary whitespace preceding a token. A linebreak before a token will be removed unless `allowLineBreaks` is set to `true`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NoWhitespaceBeforeVisitor();
    }

    private static class NoWhitespaceBeforeVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        SpacesStyle spacesStyle;
        NoWhitespaceBeforeStyle noWhitespaceBeforeStyle;
        @Nullable
        EmptyForInitializerPadStyle emptyForInitializerPadStyle;
        @Nullable
        EmptyForIteratorPadStyle emptyForIteratorPadStyle;

        private NoWhitespaceBeforeVisitor() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                this.spacesStyle = cu.getStyle(SpacesStyle.class) == null ? IntelliJ.spaces() : (SpacesStyle)cu.getStyle(SpacesStyle.class);
                this.noWhitespaceBeforeStyle = cu.getStyle(NoWhitespaceBeforeStyle.class) == null ? Checkstyle.noWhitespaceBeforeStyle() : (NoWhitespaceBeforeStyle)cu.getStyle(NoWhitespaceBeforeStyle.class);
                this.emptyForInitializerPadStyle = (EmptyForInitializerPadStyle)cu.getStyle(EmptyForInitializerPadStyle.class);
                this.emptyForIteratorPadStyle = (EmptyForIteratorPadStyle)cu.getStyle(EmptyForIteratorPadStyle.class);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getDot())) {
                if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getAllowLineBreaks()) && ((J.FieldAccess)f).getPadding().getName().getBefore().getWhitespace().contains("\n")) {
                    return f;
                }
                if (((J.FieldAccess)f).getPadding().getName().getBefore().getWhitespace().contains(" ")) {
                    f = ((J.FieldAccess)f).getPadding().withName(((J.FieldAccess)f).getPadding().getName().withBefore(((J.FieldAccess)f).getPadding().getName().getBefore().withWhitespace("")));
                }
            }
            return f;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getDot())) {
                if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getAllowLineBreaks()) && ((J.MethodInvocation)m).getPadding().getSelect() != null && ((J.MethodInvocation)m).getPadding().getSelect().getAfter().getWhitespace().contains("\n")) {
                    return m;
                }
                if (((J.MethodInvocation)m).getPadding().getSelect() != null && ((J.MethodInvocation)m).getPadding().getSelect().getAfter().getWhitespace().contains(" ")) {
                    m = ((J.MethodInvocation)m).getPadding().withSelect(((J.MethodInvocation)m).getPadding().getSelect().withAfter(((J.MethodInvocation)m).getPadding().getSelect().getAfter().withWhitespace("")));
                }
            }
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getComma())) {
                m = (J.MethodInvocation)new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle).visitNonNull(m, ctx);
            }
            return m;
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
            J f = super.visitForLoop(forLoop, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getSemi())) {
                f = (J.ForLoop)new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle).visitNonNull(f, ctx);
            }
            return f;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J vd = super.visitVariableDeclarations(multiVariable, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getComma())) {
                if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getAllowLineBreaks()) && ((J.VariableDeclarations)vd).getPadding().getVariables().stream().anyMatch(v -> v.getAfter().getWhitespace().contains("\n"))) {
                    return vd;
                }
                vd = ((J.VariableDeclarations)vd).getPadding().withVariables(ListUtils.map(((J.VariableDeclarations)vd).getPadding().getVariables(), v -> {
                    v = v.withAfter(v.getAfter().withWhitespace(""));
                    return v;
                }));
            }
            return vd;
        }

        @Override
        public J.Unary visitUnary(J.Unary unary, ExecutionContext ctx) {
            J u = super.visitUnary(unary, ctx);
            J.Unary.Type op = ((J.Unary)u).getOperator();
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getPostInc()) && op == J.Unary.Type.PostIncrement || Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getPostDec() != false && op == J.Unary.Type.PostDecrement)) {
                if (Boolean.FALSE.equals(this.noWhitespaceBeforeStyle.getAllowLineBreaks()) && ((J.Unary)u).getPadding().getOperator().getBefore().getWhitespace().contains("\n")) {
                    u = ((J.Unary)u).getPadding().withOperator(((J.Unary)u).getPadding().getOperator().withBefore(((J.Unary)u).getPadding().getOperator().getBefore().withWhitespace("")));
                }
                u = (J.Unary)new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle).visitNonNull(u, ctx);
            }
            return u;
        }

        @Override
        public J.ParameterizedType visitParameterizedType(J.ParameterizedType type, ExecutionContext ctx) {
            J p = super.visitParameterizedType(type, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getGenericStart()) && ((J.ParameterizedType)p).getPadding().getTypeParameters() != null) {
                p = ((J.ParameterizedType)p).getPadding().withTypeParameters(((J.ParameterizedType)p).getPadding().getTypeParameters().withBefore(((J.ParameterizedType)p).getPadding().getTypeParameters().getBefore().withWhitespace("")));
            }
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getGenericEnd()) && ((J.ParameterizedType)p).getPadding().getTypeParameters() != null) {
                p = ((J.ParameterizedType)p).getPadding().withTypeParameters(((J.ParameterizedType)p).getPadding().getTypeParameters().getPadding().withElements(ListUtils.map(((J.ParameterizedType)p).getPadding().getTypeParameters().getPadding().getElements(), e -> {
                    e = e.withAfter(e.getAfter().withWhitespace(""));
                    return e;
                })));
            }
            return p;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
            J m = super.visitMemberReference(memberRef, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getMethodRef())) {
                if (Boolean.TRUE.equals(this.noWhitespaceBeforeStyle.getAllowLineBreaks()) && ((J.MemberReference)m).getPadding().getContaining().getAfter().getWhitespace().contains("\n")) {
                    return m;
                }
                m = ((J.MemberReference)m).getPadding().withContaining(((J.MemberReference)m).getPadding().getContaining().withAfter(((J.MemberReference)m).getPadding().getContaining().getAfter().withWhitespace("")));
            }
            return m;
        }
    }
}

