/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

public class WrappingAndBracesVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final WrappingAndBracesStyle style;

    public WrappingAndBracesVisitor(WrappingAndBracesStyle style) {
        this(style, null);
    }

    public WrappingAndBracesVisitor(WrappingAndBracesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        J j = super.visitStatement(statement, (Object)p);
        J parentTree = (J)this.getCursor().getParentTreeCursor().getValue();
        if (parentTree instanceof J.Block && !(j instanceof J.EnumValueSet) && !j.getPrefix().getWhitespace().contains("\n")) {
            j = (Statement)j.withPrefix(this.withNewline(j.getPrefix()));
        }
        return j;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)p);
        if (this.getCursor().getParent() != null && this.getCursor().getParent().firstEnclosing(J.class) instanceof J.Block && !((J.VariableDeclarations)(variableDeclarations = ((J.VariableDeclarations)variableDeclarations).withLeadingAnnotations(this.withNewlines(((J.VariableDeclarations)variableDeclarations).getLeadingAnnotations())))).getLeadingAnnotations().isEmpty()) {
            if (!((J.VariableDeclarations)variableDeclarations).getModifiers().isEmpty()) {
                variableDeclarations = ((J.VariableDeclarations)variableDeclarations).withModifiers(this.withNewline(((J.VariableDeclarations)variableDeclarations).getModifiers()));
            } else if (((J.VariableDeclarations)variableDeclarations).getTypeExpression() != null && !((J.VariableDeclarations)variableDeclarations).getTypeExpression().getPrefix().getWhitespace().contains("\n")) {
                variableDeclarations = ((J.VariableDeclarations)variableDeclarations).withTypeExpression((TypeTree)((J.VariableDeclarations)variableDeclarations).getTypeExpression().withPrefix(this.withNewline(((J.VariableDeclarations)variableDeclarations).getTypeExpression().getPrefix())));
            }
        }
        return variableDeclarations;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J m = super.visitMethodDeclaration(method, (Object)p);
        if (!((J.MethodDeclaration)(m = ((J.MethodDeclaration)m).withLeadingAnnotations(this.withNewlines(((J.MethodDeclaration)m).getLeadingAnnotations())))).getLeadingAnnotations().isEmpty()) {
            if (!((J.MethodDeclaration)m).getModifiers().isEmpty()) {
                m = ((J.MethodDeclaration)m).withModifiers(this.withNewline(((J.MethodDeclaration)m).getModifiers()));
            } else if (((J.MethodDeclaration)m).getAnnotations().getTypeParameters() != null) {
                if (!((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getPrefix().getWhitespace().contains("\n")) {
                    m = ((J.MethodDeclaration)m).getAnnotations().withTypeParameters(((J.MethodDeclaration)m).getAnnotations().getTypeParameters().withPrefix(this.withNewline(((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getPrefix())));
                }
            } else if (((J.MethodDeclaration)m).getReturnTypeExpression() != null) {
                if (!((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix().getWhitespace().contains("\n")) {
                    m = ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)((J.MethodDeclaration)m).getReturnTypeExpression().withPrefix(this.withNewline(((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix())));
                }
            } else if (!((J.MethodDeclaration)m).getName().getPrefix().getWhitespace().contains("\n")) {
                m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(this.withNewline(((J.MethodDeclaration)m).getName().getPrefix())));
            }
        }
        return m;
    }

    @Override
    public J.If.Else visitElse(J.If.Else else_, P p) {
        boolean hasBody;
        J e = super.visitElse(else_, (Object)p);
        boolean bl = hasBody = ((J.If.Else)e).getBody() instanceof J.Block || ((J.If.Else)e).getBody() instanceof J.If;
        if (hasBody) {
            if (this.style.getIfStatement().getElseOnNewLine().booleanValue() && !((J.If.Else)e).getPrefix().getWhitespace().contains("\n")) {
                e = ((J.If.Else)e).withPrefix(((J.If.Else)e).getPrefix().withWhitespace("\n" + ((J.If.Else)e).getPrefix().getWhitespace()));
            } else if (!this.style.getIfStatement().getElseOnNewLine().booleanValue() && ((J.If.Else)e).getPrefix().getWhitespace().contains("\n")) {
                e = ((J.If.Else)e).withPrefix(Space.EMPTY);
            }
        }
        return e;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J j = super.visitClassDeclaration(classDecl, (Object)p);
        if (!((J.ClassDeclaration)(j = ((J.ClassDeclaration)j).withLeadingAnnotations(this.withNewlines(((J.ClassDeclaration)j).getLeadingAnnotations())))).getLeadingAnnotations().isEmpty()) {
            if (!((J.ClassDeclaration)j).getModifiers().isEmpty()) {
                j = ((J.ClassDeclaration)j).withModifiers(this.withNewline(((J.ClassDeclaration)j).getModifiers()));
            } else {
                J.ClassDeclaration.Kind kind = ((J.ClassDeclaration)j).getAnnotations().getKind();
                if (!kind.getPrefix().getWhitespace().contains("\n")) {
                    j = ((J.ClassDeclaration)j).getAnnotations().withKind(kind.withPrefix(kind.getPrefix().withWhitespace("\n" + kind.getPrefix().getWhitespace())));
                }
            }
        }
        return j;
    }

    private List<J.Annotation> withNewlines(List<J.Annotation> annotations) {
        if (annotations.isEmpty()) {
            return annotations;
        }
        return ListUtils.map(annotations, (index, a) -> {
            if (index != 0 && !a.getPrefix().getWhitespace().contains("\n")) {
                a = a.withPrefix(this.withNewline(a.getPrefix()));
            }
            return a;
        });
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        if (!((J.Block)b).getEnd().getWhitespace().contains("\n")) {
            b = ((J.Block)b).withEnd(this.withNewline(((J.Block)b).getEnd()));
        }
        return b;
    }

    private Space withNewline(Space space) {
        if (space.getComments().isEmpty()) {
            space = space.withWhitespace("\n" + space.getWhitespace());
        } else if (space.getComments().get(space.getComments().size() - 1).isMultiline()) {
            space = space.withComments(ListUtils.mapLast(space.getComments(), c -> c.withSuffix("\n")));
        }
        return space;
    }

    private List<J.Modifier> withNewline(List<J.Modifier> modifiers) {
        J.Modifier firstModifier = modifiers.iterator().next();
        if (!firstModifier.getPrefix().getWhitespace().contains("\n")) {
            return ListUtils.mapFirst(modifiers, mod -> mod.withPrefix(this.withNewline(mod.getPrefix())));
        }
        return modifiers;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

