/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.tree.JavaType;

public class UnsafeJavaTypeVisitor<P>
extends JavaTypeVisitor<P> {
    @Override
    public JavaType visitClass(JavaType.Class aClass, P p) {
        return aClass.unsafeSet(ListUtils.map(aClass.getTypeParameters(), t -> this.visit((JavaType)t, p)), (JavaType.FullyQualified)this.visit(aClass.getSupertype(), p), (JavaType.FullyQualified)this.visit(aClass.getOwningClass(), p), ListUtils.map(aClass.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)), ListUtils.map(aClass.getInterfaces(), i -> (JavaType.FullyQualified)this.visit((JavaType)i, p)), ListUtils.map(aClass.getMembers(), m -> (JavaType.Variable)this.visit((JavaType)m, p)), ListUtils.map(aClass.getMethods(), m -> (JavaType.Method)this.visit((JavaType)m, p)));
    }

    @Override
    public JavaType visitArray(JavaType.Array array, P p) {
        return array.unsafeSet(this.visit(array.getElemType(), p));
    }

    @Override
    public JavaType visitParameterized(JavaType.Parameterized parameterized, P p) {
        return parameterized.unsafeSet((JavaType.FullyQualified)this.visit(parameterized.getType(), p), ListUtils.map(parameterized.getTypeParameters(), t -> this.visit((JavaType)t, p)));
    }

    @Override
    public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, P p) {
        return generic.unsafeSet(generic.getName(), generic.getVariance(), ListUtils.map(generic.getBounds(), b -> this.visit((JavaType)b, p)));
    }

    @Override
    public JavaType visitMethod(JavaType.Method method, P p) {
        return method.unsafeSet((JavaType.FullyQualified)this.visit(method.getDeclaringType(), p), this.visit(method.getReturnType(), p), ListUtils.map(method.getParameterTypes(), pt -> this.visit((JavaType)pt, p)), ListUtils.map(method.getThrownExceptions(), t -> (JavaType.FullyQualified)this.visit((JavaType)t, p)), ListUtils.map(method.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
    }

    @Override
    public JavaType visitVariable(JavaType.Variable variable, P p) {
        return variable.unsafeSet(this.visit(variable.getOwner(), p), this.visit(variable.getType(), p), ListUtils.map(variable.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
    }

    @Override
    public JavaType visitMultiCatch(JavaType.MultiCatch multiCatch, P p) {
        return multiCatch.unsafeSet(ListUtils.map(multiCatch.getThrowableTypes(), t -> this.visit((JavaType)t, p)));
    }
}

