/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ImplementInterface<P>
extends JavaIsoVisitor<P> {
    private final J.ClassDeclaration scope;
    private final JavaType.FullyQualified interfaceType;
    @Nullable
    private final List<Expression> typeParameters;

    public ImplementInterface(J.ClassDeclaration scope, JavaType.FullyQualified interfaceType, @Nullable List<Expression> typeParameters) {
        this.scope = scope;
        this.interfaceType = interfaceType;
        this.typeParameters = typeParameters;
    }

    public ImplementInterface(J.ClassDeclaration scope, String interface_, @Nullable List<Expression> typeParameters) {
        this(scope, ListUtils.nullIfEmpty(typeParameters) != null ? new JavaType.Parameterized(null, (JavaType.FullyQualified)JavaType.ShallowClass.build(interface_), typeParameters.stream().map(Expression::getType).collect(Collectors.toList())) : JavaType.ShallowClass.build(interface_), typeParameters);
    }

    public ImplementInterface(J.ClassDeclaration scope, JavaType.FullyQualified interfaceType) {
        this(scope, interfaceType, null);
    }

    public ImplementInterface(J.ClassDeclaration scope, String interface_) {
        this(scope, interface_, null);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        if (c.isScope(this.scope) && (((J.ClassDeclaration)c).getImplements() == null || ((J.ClassDeclaration)c).getImplements().stream().noneMatch(f -> TypeUtils.isAssignableTo(f.getType(), (JavaType)this.interfaceType)))) {
            if (!classDecl.getSimpleName().equals(this.interfaceType.getClassName())) {
                this.maybeAddImport(this.interfaceType);
            }
            TypeTree impl = (TypeTree)TypeTree.build(classDecl.getSimpleName().equals(this.interfaceType.getClassName()) ? this.interfaceType.getFullyQualifiedName() : this.interfaceType.getClassName()).withType(this.interfaceType).withPrefix(Space.format(" "));
            if (this.typeParameters != null && !this.typeParameters.isEmpty()) {
                this.typeParameters.stream().map(Expression::getType).map(t -> t instanceof JavaType.FullyQualified ? (JavaType.FullyQualified)t : null).filter(Objects::nonNull).forEach(t -> this.maybeAddImport(t.getFullyQualifiedName()));
                List elements = this.typeParameters.stream().map(t -> new JRightPadded<Expression>((Expression)t, Space.EMPTY, Markers.EMPTY)).collect(Collectors.toList());
                J.ParameterizedType typedImpl = new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, impl, JContainer.build(Space.EMPTY, elements, Markers.EMPTY), this.interfaceType);
                c = ((J.ClassDeclaration)c).withImplements(ListUtils.concat(((J.ClassDeclaration)c).getImplements(), (Object)typedImpl));
            } else {
                c = ((J.ClassDeclaration)c).withImplements(ListUtils.concat(((J.ClassDeclaration)c).getImplements(), (Object)impl));
            }
            JContainer<TypeTree> anImplements = ((J.ClassDeclaration)c).getPadding().getImplements();
            assert (anImplements != null);
            if (anImplements.getBefore().getWhitespace().isEmpty()) {
                c = ((J.ClassDeclaration)c).getPadding().withImplements(anImplements.withBefore(Space.format(" ")));
            }
        }
        return c;
    }
}

