/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateTestToRewrite8
extends Recipe {
    private static final String REWRITE_TEST_FQN = "org.openrewrite.test.RewriteTest";
    private static final MethodMatcher RECIPE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RecipeSpec recipe(org.openrewrite.Recipe)");
    private static final MethodMatcher DO_NEXT_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Recipe doNext(org.openrewrite.Recipe)");

    public String getDisplayName() {
        return "Migrate rewrite unit test from version 7 to 8";
    }

    public String getDescription() {
        return "Since the method `Recipe::doNext(..)` is deprecated, For unit test, change usage like `RecipeSpec.recipe(X.doNext(Y))` to `RecipeSpec.recipes(X, Y)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("Rewrite8 migration");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                if (classDecl.getImplements() != null) {
                    if (classDecl.getImplements().stream().noneMatch(c -> TypeUtils.isOfClassType(c.getType(), MigrateTestToRewrite8.REWRITE_TEST_FQN))) {
                        return classDecl;
                    }
                } else {
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, executionContext);
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                method = super.visitMethodInvocation((J.MethodInvocation)method, ctx);
                if (RECIPE_METHOD_MATCHER.matches(((J.MethodInvocation)method).getMethodType())) {
                    ((J.MethodInvocation)method).getArguments();
                    if (((J.MethodInvocation)method).getArguments().isEmpty()) {
                        return method;
                    }
                    List recipes = MigrateTestToRewrite8.flatDoNext(((J.MethodInvocation)method).getArguments().get(0));
                    if (recipes.size() > 1) {
                        String argsPlaceHolders = String.join((CharSequence)",", Collections.nCopies(recipes.size(), "#{any()}"));
                        JavaTemplate recipesTemplate = JavaTemplate.builder("#{any()}.recipes(" + argsPlaceHolders + ")").contextSensitive().javaParser((JavaParser.Builder<?, ?>)((Object)JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))).imports("org.openrewrite.test.RecipeSpec", MigrateTestToRewrite8.REWRITE_TEST_FQN).build();
                        Object[] parameters = new Object[recipes.size() + 1];
                        parameters[0] = ((J.MethodInvocation)method).getSelect();
                        for (int i = 0; i < recipes.size(); ++i) {
                            parameters[i + 1] = recipes.get(i);
                        }
                        return (J.MethodInvocation)recipesTemplate.apply(this.getCursor(), ((J.MethodInvocation)method).getCoordinates().replace(), parameters);
                    }
                }
                return method;
            }
        };
    }

    private static List<Expression> flatDoNext(Expression expression) {
        ArrayList<Expression> recipes = new ArrayList<Expression>();
        if (!(expression instanceof J.MethodInvocation)) {
            recipes.add(expression);
            return recipes;
        }
        J.MethodInvocation method = (J.MethodInvocation)expression;
        if (DO_NEXT_METHOD_MATCHER.matches(method) && method.getSelect() != null) {
            recipes.addAll(MigrateTestToRewrite8.flatDoNext(method.getSelect()));
            recipes.addAll(MigrateTestToRewrite8.flatDoNext(method.getArguments().get(0)));
        }
        return recipes;
    }
}

