/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class MigrateRecipeToRewrite8
extends Recipe {
    private static final String REWRITE_RECIPE_FQN = "org.openrewrite.Recipe";
    private static final String JAVA_ISO_VISITOR_FQN = "org.openrewrite.java.JavaIsoVisitor";
    private static final String JAVA_VISITOR_FQN = "org.openrewrite.java.JavaVisitor";
    private static final MethodMatcher GET_SINGLE_SOURCE_APPLICABLE_TEST_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Recipe getSingleSourceApplicableTest()", true);
    private static final MethodMatcher GET_APPLICABLE_TEST_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Recipe getApplicableTest()", true);
    private static final MethodMatcher GET_VISITOR_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Recipe getVisitor()", true);
    private static final MethodMatcher VISIT_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Recipe visit(..)", true);
    private static final AnnotationMatcher OVERRIDE_ANNOTATION_MATCHER = new AnnotationMatcher("@java.lang.Override");
    private static final MethodMatcher VISIT_JAVA_SOURCE_FILE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.java.JavaVisitor visitJavaSourceFile(..)", true);
    private static final MethodMatcher TREE_VISITOR_VISIT_METHOD_MATCHER = new MethodMatcher("org.openrewrite.TreeVisitor visit(..)", true);
    private static final MethodMatcher APPLICABILITY_AND_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Applicability and(..)");
    private static final MethodMatcher APPLICABILITY_OR_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Applicability or(..)");
    private static final MethodMatcher APPLICABILITY_NOT_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Applicability not(..)");
    private static final MethodMatcher DO_NEXT_METHOD_MATCHER = new MethodMatcher("org.openrewrite.Recipe doNext(..)");
    @Nullable
    private static J.ParameterizedType getVisitorReturnTypeTemplate;
    @Nullable
    private static J.MethodDeclaration visitTreeMethodDeclarationTemplate;
    @Nullable
    private static J.MethodInvocation visitTreeMethodInvocationTemplate;
    @Nullable
    private static J.TypeCast visitTreeMethodInvocationTypeCastTemplate;
    @Nullable
    private static J.MethodInvocation preconditionAndTemplate;
    @Nullable
    private static J.MethodInvocation preconditionOrTemplate;
    @Nullable
    private static J.MethodInvocation preconditionNotTemplate;
    @Nullable
    private static J.MemberReference visitMemberReferenceTemplate;
    public static final String MIGRATION_GUIDE_URL = "https://to-be-written";
    private static final String PLEASE_FOLLOW_MIGRATION_GUIDE = "please follow the migration guide here: https://to-be-written";
    private static final String VISIT_SOURCE_FILES_COMMENT = " [Rewrite8 migration] This recipe uses the visit multiple sources method `visit(List<SourceFile> before, P p)`, needs to be migrated to use new introduced scanning recipe, please follow the migration guide here: https://to-be-written";
    private static final String DO_NEXT_COMMENT = " [Rewrite8 migration] Method `Recipe#doNext(..)` is removed, you might want to change the recipe to be a scanning recipe, or just simply replace to use `TreeVisitor#doAfterVisit`, please follow the migration guide here: https://to-be-written";
    private static final String APPLICABLE_TEST_COMMENT = " [Rewrite8 migration] Method `Recipe#getApplicableTest(..)` is deprecated and needs to be converted to a `ScanningRecipe`. Or you can use `Precondition#check()` if it is meant to use a single-source applicability test. please follow the migration guide here: https://to-be-written";
    private static final String COMPLEX_SINGLE_SOURCE_APPLICABLE_TEST_COMMENT = " [Rewrite8 migration] This getSingleSourceApplicableTest methods might have multiple returns, need manually migrate to use `Precondition#check()`, please follow the migration guide here: https://to-be-written";
    private static final String VISIT_TREE_METHOD_TEMPLATE_CODE = "import org.openrewrite.Tree;\nimport org.openrewrite.internal.lang.Nullable;\nimport org.openrewrite.java.JavaIsoVisitor;\nimport org.openrewrite.java.tree.J;\nimport org.openrewrite.java.tree.JavaSourceFile;\npublic class A<P> extends JavaIsoVisitor<P> {\n    @Override\n    public @Nullable J visit(@Nullable Tree tree, P p) {\n        if (tree instanceof JavaSourceFile) {\n            JavaSourceFile toBeReplaced = (JavaSourceFile) tree;\n        }\n        return super.visit(tree, p);\n    }\n}";

    public String getDisplayName() {
        return "Migrate Rewrite recipes from version 7 to 8";
    }

    public String getDescription() {
        return "Rewrite Recipe Migration to version 8. While most parts can be automatically migrated, there are some complex and open-ended scenarios that require manual attention. In those cases, this recipe will add a comment to the code and request a human to review and handle it manually.";
    }

    public Set<String> getTags() {
        return Collections.singleton("Rewrite8 migration");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            boolean hasApplicableTest = false;
            final List<Statement> applicableTestMethodStatements = new ArrayList<Statement>();
            boolean applicableTestMethodHasMultipleReturns = false;

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext executionContext) {
                if (VISIT_JAVA_SOURCE_FILE_METHOD_MATCHER.matches(memberRef.getMethodType())) {
                    this.maybeAddImport("org.openrewrite.TreeVisitor");
                    return MigrateRecipeToRewrite8.getVisitMemberReferenceTemplate();
                }
                return memberRef;
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (MigratedTo8.hasMarker(method)) {
                    return method;
                }
                method = super.visitMethodInvocation((J.MethodInvocation)method, ctx);
                if (DO_NEXT_METHOD_MATCHER.matches(((J.MethodInvocation)method).getMethodType())) {
                    return MigratedTo8.withMarker((J.MethodInvocation)MigrateRecipeToRewrite8.commentOf(method, MigrateRecipeToRewrite8.DO_NEXT_COMMENT));
                }
                return method;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.MethodDeclaration visitMethod;
                if (MigratedTo8.hasMarker(classDecl)) {
                    return classDecl;
                }
                if (classDecl.getExtends() != null) {
                    JavaType extendsType = classDecl.getExtends().getType();
                    if (!(TypeUtils.isOfClassType(extendsType, MigrateRecipeToRewrite8.REWRITE_RECIPE_FQN) || TypeUtils.isOfClassType(extendsType, MigrateRecipeToRewrite8.JAVA_ISO_VISITOR_FQN) || TypeUtils.isOfClassType(extendsType, MigrateRecipeToRewrite8.JAVA_VISITOR_FQN))) {
                        return classDecl;
                    }
                } else {
                    return classDecl;
                }
                J.MethodDeclaration singleSourceApplicableTestMethod = MigrateRecipeToRewrite8.findSingleSourceApplicableTest(classDecl);
                if (singleSourceApplicableTestMethod != null) {
                    this.hasApplicableTest = true;
                    boolean bl = this.applicableTestMethodHasMultipleReturns = ((AtomicInteger)new JavaIsoVisitor<AtomicInteger>(){

                        @Override
                        public J.Return visitReturn(J.Return _return, AtomicInteger returnsCount) {
                            returnsCount.set(returnsCount.get() + 1);
                            return _return;
                        }
                    }.reduce(singleSourceApplicableTestMethod, new AtomicInteger(0))).get() > 1;
                    if (!this.applicableTestMethodHasMultipleReturns && singleSourceApplicableTestMethod.getBody() != null) {
                        List<Statement> statements = singleSourceApplicableTestMethod.getBody().getStatements();
                        this.applicableTestMethodStatements.addAll(statements);
                    }
                }
                if ((visitMethod = MigrateRecipeToRewrite8.findVisitMethod(classDecl)) != null) {
                    classDecl = MigratedTo8.withMarker(classDecl);
                    return (J.ClassDeclaration)new JavaIsoVisitor<ExecutionContext>(){

                        @Override
                        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                            if (VISIT_METHOD_MATCHER.matches(method.getMethodType())) {
                                return (J.MethodDeclaration)MigrateRecipeToRewrite8.commentOf(method, MigrateRecipeToRewrite8.VISIT_SOURCE_FILES_COMMENT);
                            }
                            return super.visitMethodDeclaration(method, executionContext);
                        }
                    }.visitNonNull(classDecl, ctx);
                }
                return super.visitClassDeclaration(classDecl, ctx);
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (MigratedTo8.hasMarker(method)) {
                    return method;
                }
                if (GET_SINGLE_SOURCE_APPLICABLE_TEST_METHOD_MATCHER.matches(method.getMethodType())) {
                    if (!this.applicableTestMethodHasMultipleReturns) {
                        return null;
                    }
                    method = (J.MethodDeclaration)MigrateRecipeToRewrite8.commentOf(method, MigrateRecipeToRewrite8.COMPLEX_SINGLE_SOURCE_APPLICABLE_TEST_COMMENT);
                    method = MigratedTo8.withMarker(method);
                    return method;
                }
                if (GET_APPLICABLE_TEST_METHOD_MATCHER.matches(method.getMethodType())) {
                    return (J.MethodDeclaration)MigrateRecipeToRewrite8.commentOf(method, MigrateRecipeToRewrite8.APPLICABLE_TEST_COMMENT);
                }
                if (GET_VISITOR_METHOD_MATCHER.matches(method.getMethodType())) {
                    if (J.Modifier.hasModifier(method.getModifiers(), J.Modifier.Type.Protected)) {
                        method = method.withModifiers(ListUtils.map(method.getModifiers(), mod -> mod.getType() == J.Modifier.Type.Protected ? mod.withType(J.Modifier.Type.Public) : mod));
                        MigratedTo8.withMarker(method);
                    }
                    if (method.getReturnTypeExpression() != null && !TypeUtils.isOfClassType(method.getReturnTypeExpression().getType(), "org.openrewrite.TreeVisitor")) {
                        this.maybeAddImport("org.openrewrite.TreeVisitor");
                        method = method.withReturnTypeExpression(MigrateRecipeToRewrite8.getGetVisitorReturnType().withPrefix(Space.SINGLE_SPACE));
                    }
                    if (this.hasApplicableTest && !this.applicableTestMethodStatements.isEmpty()) {
                        int i;
                        this.maybeAddImport("org.openrewrite.Preconditions", false);
                        if (method.getBody() == null) {
                            return method;
                        }
                        List<Statement> getVisitorStatements = method.getBody().getStatements();
                        Statement getVisitorReturnStatements = null;
                        Statement applicableTestReturnStatement = null;
                        ArrayList<Statement> mergedStatements = new ArrayList<Statement>();
                        for (i = 0; i < this.applicableTestMethodStatements.size(); ++i) {
                            if (i != this.applicableTestMethodStatements.size() - 1) {
                                mergedStatements.add(this.applicableTestMethodStatements.get(i));
                                continue;
                            }
                            applicableTestReturnStatement = this.applicableTestMethodStatements.get(i);
                        }
                        for (i = 0; i < getVisitorStatements.size(); ++i) {
                            if (i != getVisitorStatements.size() - 1) {
                                mergedStatements.add(getVisitorStatements.get(i));
                                continue;
                            }
                            getVisitorReturnStatements = getVisitorStatements.get(i);
                        }
                        if (getVisitorReturnStatements == null || applicableTestReturnStatement == null) {
                            return method;
                        }
                        getVisitorReturnStatements = (Statement)JavaTemplate.builder("return Preconditions.check(#{any()}, #{any()});").javaParser((JavaParser.Builder<?, ?>)((Object)JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))).imports("org.openrewrite.Preconditions").build().apply(new Cursor(this.getCursor(), (Object)getVisitorReturnStatements), getVisitorReturnStatements.getCoordinates().replace(), ((J.Return)applicableTestReturnStatement).getExpression(), ((J.Return)getVisitorReturnStatements).getExpression());
                        mergedStatements.add(getVisitorReturnStatements);
                        method = method.withBody(method.getBody().withStatements(mergedStatements));
                        method = (J.MethodDeclaration)MigrateRecipeToRewrite8.replaceApplicabilityMethods(method, ctx);
                        return MigratedTo8.withMarker((J.MethodDeclaration)this.autoFormat(super.visitMethodDeclaration(method, ctx), ctx));
                    }
                    return super.visitMethodDeclaration(method, ctx);
                }
                if (VISIT_JAVA_SOURCE_FILE_METHOD_MATCHER.matches(method.getMethodType()) && method.getBody() != null) {
                    List<Statement> visitJavaSourceFileMethodStatements = method.getBody().getStatements();
                    visitJavaSourceFileMethodStatements.remove(visitJavaSourceFileMethodStatements.size() - 1);
                    J.MethodDeclaration visitMethod = MigrateRecipeToRewrite8.buildVisitMethod(method.getParameters());
                    if (visitMethod.getBody() == null) {
                        return method;
                    }
                    List<Statement> visitMethodStatements = visitMethod.getBody().getStatements();
                    J.If ifStatement = (J.If)visitMethodStatements.get(0);
                    J.Block ifBlock = (J.Block)ifStatement.getThenPart();
                    List<Statement> mergedIfBlockStatements = ifBlock.getStatements();
                    mergedIfBlockStatements.addAll(1, visitJavaSourceFileMethodStatements);
                    J.Block mergedIfBlock = ifBlock.withStatements(mergedIfBlockStatements);
                    J.If updatedIfStatement = ifStatement.withThenPart(mergedIfBlock);
                    visitMethod = visitMethod.withBody(visitMethod.getBody().withStatements(ListUtils.mapFirst(visitMethodStatements, a -> updatedIfStatement)));
                    visitMethod = (J.MethodDeclaration)new JavaVisitor<ExecutionContext>(){

                        @Override
                        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                            if (VISIT_JAVA_SOURCE_FILE_METHOD_MATCHER.matches(method.getMethodType())) {
                                boolean isVariableDeclaration = this.getCursor().dropParentUntil(p -> p instanceof J.VariableDeclarations || p instanceof J.Block || p instanceof J.MethodDeclaration).getValue() instanceof J.VariableDeclarations;
                                if (isVariableDeclaration) {
                                    J.TypeCast typeCast = MigrateRecipeToRewrite8.getVisitMethodInvocationTypeCastTemplate();
                                    MethodCall exp = ((J.MethodInvocation)typeCast.getExpression()).withSelect(method.getSelect()).withArguments((List)method.getArguments());
                                    return typeCast.withExpression(exp);
                                }
                                return MigrateRecipeToRewrite8.getVisitMethodInvocationTemplate().withSelect(method.getSelect()).withArguments((List)method.getArguments());
                            }
                            return super.visitMethodInvocation(method, executionContext);
                        }

                        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext executionContext) {
                            if (VISIT_JAVA_SOURCE_FILE_METHOD_MATCHER.matches(memberRef.getMethodType())) {
                                this.maybeAddImport("org.openrewrite.TreeVisitor");
                                return MigrateRecipeToRewrite8.getVisitMemberReferenceTemplate();
                            }
                            return memberRef;
                        }
                    }.visitNonNull(visitMethod, ctx);
                    this.maybeAddImport("org.openrewrite.internal.lang.Nullable");
                    this.maybeAddImport("org.openrewrite.Tree");
                    this.maybeAddImport("org.openrewrite.java.tree.J");
                    return this.autoFormat(visitMethod, ctx);
                }
                return super.visitMethodDeclaration(method, ctx);
            }
        };
    }

    @Nullable
    private static J.MethodDeclaration findSingleSourceApplicableTest(J.ClassDeclaration classDecl) {
        return classDecl.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).filter(m -> GET_SINGLE_SOURCE_APPLICABLE_TEST_METHOD_MATCHER.matches(m.getMethodType())).findFirst().orElse(null);
    }

    @Nullable
    private static J.MethodDeclaration findVisitMethod(J.ClassDeclaration classDecl) {
        return classDecl.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).filter(m -> VISIT_METHOD_MATCHER.matches(m.getMethodType())).filter(m -> m.getLeadingAnnotations().stream().anyMatch(OVERRIDE_ANNOTATION_MATCHER::matches)).findFirst().orElse(null);
    }

    private static J replaceApplicabilityMethods(J tree, ExecutionContext ctx) {
        return (J)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                method = super.visitMethodInvocation((J.MethodInvocation)method, executionContext);
                if (APPLICABILITY_AND_METHOD_MATCHER.matches(((J.MethodInvocation)method).getMethodType())) {
                    method = MigrateRecipeToRewrite8.getPreconditionsAndTemplate().withArguments((List)((J.MethodInvocation)method).getArguments());
                } else if (APPLICABILITY_OR_METHOD_MATCHER.matches(((J.MethodInvocation)method).getMethodType())) {
                    method = MigrateRecipeToRewrite8.getPreconditionsOrTemplate().withArguments((List)((J.MethodInvocation)method).getArguments());
                } else if (APPLICABILITY_NOT_METHOD_MATCHER.matches(((J.MethodInvocation)method).getMethodType())) {
                    method = MigrateRecipeToRewrite8.getPreconditionsNotTemplate().withArguments((List)((J.MethodInvocation)method).getArguments());
                }
                return method;
            }
        }.visitNonNull(tree, ctx);
    }

    private static J.MethodDeclaration buildVisitMethod(List<Statement> visitJavaSourceFileMethodParameters) {
        J.MethodDeclaration visitMethodTemplate = MigrateRecipeToRewrite8.getVisitTreeMethodTemplate();
        final J.Identifier javaSourceFiledId = ((J.VariableDeclarations)visitJavaSourceFileMethodParameters.get(0)).getVariables().get(0).getName();
        J.Identifier secondParameter = ((J.VariableDeclarations)visitJavaSourceFileMethodParameters.get(1)).getVariables().get(0).getName();
        J.MethodDeclaration visitMethod = visitMethodTemplate.withParameters(ListUtils.mapLast(visitMethodTemplate.getParameters(), a -> (Statement)visitJavaSourceFileMethodParameters.get(1)));
        return (J.MethodDeclaration)new JavaIsoVisitor<J.Identifier>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, J.Identifier replacement) {
                if (TREE_VISITOR_VISIT_METHOD_MATCHER.matches(method.getMethodType())) {
                    return method.withArguments(ListUtils.mapLast(method.getArguments(), a -> replacement.withPrefix(Space.SINGLE_SPACE)));
                }
                return method;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, J.Identifier identifier) {
                if (TypeUtils.isOfClassType(multiVariable.getType(), "org.openrewrite.java.tree.JavaSourceFile")) {
                    List variables = multiVariable.getVariables();
                    variables = ListUtils.mapLast(variables, a -> a.withName(javaSourceFiledId));
                    return multiVariable.withVariables(variables);
                }
                return multiVariable;
            }
        }.visitNonNull(visitMethod, secondParameter);
    }

    public static J commentOf(J j, String commentText) {
        TextComment comment = new TextComment(false, commentText, "\n" + j.getPrefix().getWhitespace().replace("\n", ""), Markers.EMPTY);
        Space prefix = j.getPrefix();
        List comments = ListUtils.concat(prefix.getComments(), (Object)comment);
        prefix = prefix.withComments(comments);
        return j.withPrefix(prefix);
    }

    private static J.ParameterizedType getGetVisitorReturnType() {
        if (getVisitorReturnTypeTemplate == null) {
            getVisitorReturnTypeTemplate = MigrateRecipeToRewrite8.parseAndBuild("import org.openrewrite.ExecutionContext;\nimport org.openrewrite.TreeVisitor;\npublic class A {\n    TreeVisitor<?, ExecutionContext> type;\n}", J.ParameterizedType.class, JavaParser.runtimeClasspath());
        }
        return getVisitorReturnTypeTemplate;
    }

    private static J.MethodDeclaration getVisitTreeMethodTemplate() {
        if (visitTreeMethodDeclarationTemplate == null) {
            visitTreeMethodDeclarationTemplate = MigrateRecipeToRewrite8.parseAndBuild(VISIT_TREE_METHOD_TEMPLATE_CODE, J.MethodDeclaration.class, JavaParser.runtimeClasspath());
        }
        return visitTreeMethodDeclarationTemplate;
    }

    private static J.MethodInvocation getVisitMethodInvocationTemplate() {
        if (visitTreeMethodInvocationTemplate == null) {
            visitTreeMethodInvocationTemplate = MigrateRecipeToRewrite8.parseAndBuild("import org.openrewrite.Tree;\nimport org.openrewrite.TreeVisitor;\nimport org.openrewrite.internal.lang.Nullable;\n\npublic class A<T extends Tree, P> extends TreeVisitor<T, P> {\n    @Override\n    public @Nullable T visit(@Nullable Tree tree, P p) {\n        return super.visit(tree, p);\n    }\n}", J.MethodInvocation.class, JavaParser.runtimeClasspath());
        }
        return visitTreeMethodInvocationTemplate;
    }

    private static J.TypeCast getVisitMethodInvocationTypeCastTemplate() {
        if (visitTreeMethodInvocationTypeCastTemplate == null) {
            visitTreeMethodInvocationTypeCastTemplate = MigrateRecipeToRewrite8.parseAndBuild("import org.openrewrite.Tree;\nimport org.openrewrite.internal.lang.Nullable;\nimport org.openrewrite.java.JavaVisitor;\nimport org.openrewrite.java.tree.JavaSourceFile;\npublic class A<P> extends JavaVisitor<P> {\n    @Override\n    public @Nullable JavaSourceFile visit(@Nullable Tree tree, P p) {\n        return (JavaSourceFile) super.visit(tree, p);\n    }\n}", J.TypeCast.class, JavaParser.runtimeClasspath());
        }
        return visitTreeMethodInvocationTypeCastTemplate;
    }

    private static J.MethodInvocation getPreconditionsAndTemplate() {
        if (preconditionAndTemplate == null) {
            preconditionAndTemplate = MigrateRecipeToRewrite8.parseAndBuild("import org.openrewrite.Preconditions;\npublic class A {\n    void method() {\n         Preconditions.and(null);\n    }\n}", J.MethodInvocation.class, JavaParser.runtimeClasspath());
        }
        return preconditionAndTemplate;
    }

    private static J.MethodInvocation getPreconditionsOrTemplate() {
        if (preconditionOrTemplate == null) {
            preconditionOrTemplate = MigrateRecipeToRewrite8.parseAndBuild("import org.openrewrite.Preconditions;\npublic class A {\n    void method() {\n         Preconditions.or(null);\n    }\n}", J.MethodInvocation.class, JavaParser.runtimeClasspath());
        }
        return preconditionOrTemplate;
    }

    private static J.MethodInvocation getPreconditionsNotTemplate() {
        if (preconditionNotTemplate == null) {
            preconditionNotTemplate = MigrateRecipeToRewrite8.parseAndBuild("import org.openrewrite.Preconditions;\npublic class A {\n    void method() {\n         Preconditions.not(null);\n    }\n}", J.MethodInvocation.class, JavaParser.runtimeClasspath());
        }
        return preconditionNotTemplate;
    }

    private static J.MemberReference getVisitMemberReferenceTemplate() {
        if (visitMemberReferenceTemplate == null) {
            visitMemberReferenceTemplate = MigrateRecipeToRewrite8.parseAndBuild("import org.openrewrite.java.JavaVisitor;\nimport org.openrewrite.java.tree.J;\nimport org.openrewrite.java.tree.JavaSourceFile;\npublic class A<P> extends JavaVisitor<P> {\n    @Override\n    public J visitJavaSourceFile(JavaSourceFile cu, P p) {\n        return visitAndCast(cu, p, super::visit);\n    }\n}", J.MemberReference.class, JavaParser.runtimeClasspath());
        }
        return visitMemberReferenceTemplate;
    }

    private static <J2 extends J> J2 parseAndBuild(@Language(value="java") String code, final Class<J2> expected, Collection<Path> classpath) {
        Object builder = JavaParser.fromJavaVersion().classpath(classpath);
        J.CompilationUnit cu = ((JavaParser.Builder)((Object)builder)).build().parse(code).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Java"));
        ArrayList parts = new ArrayList(1);
        new JavaVisitor<List<J2>>(){

            @Nullable
            public J visit(@Nullable Tree tree, List<J2> j2s) {
                if (expected.isInstance(tree)) {
                    J j2 = (J)tree;
                    j2s.add(j2);
                    return j2;
                }
                return (J)super.visit(tree, j2s);
            }
        }.visit(cu, parts);
        return (J2)((J)parts.get(0));
    }

    private static final class MigratedTo8
    implements Marker {
        private final UUID id;

        static <J2 extends J> J2 withMarker(J2 j) {
            return (J2)((J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new MigratedTo8(Tree.randomId()))));
        }

        static boolean hasMarker(J j) {
            return j.getMarkers().findFirst(MigratedTo8.class).isPresent();
        }

        public MigratedTo8(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MigratedTo8)) {
                return false;
            }
            MigratedTo8 other = (MigratedTo8)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MigrateRecipeToRewrite8.MigratedTo8(id=" + this.getId() + ")";
        }

        @NonNull
        public MigratedTo8 withId(UUID id) {
            return this.id == id ? this : new MigratedTo8(id);
        }
    }
}

