/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class UseDiamondOperator
extends Recipe {
    public String getDisplayName() {
        return "Use diamond operator";
    }

    public String getDescription() {
        return "The diamond operator (`<>`) should be used. Java 7 introduced the diamond operator (<>) to reduce the verbosity of generics code. For instance, instead of having to declare a List's type in both its declaration and its constructor, you can now simplify the constructor declaration with `<>`, and the compiler will infer the type.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2293");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseDiamondOperatorVisitor();
    }

    private static class UseDiamondOperatorVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private UseDiamondOperatorVisitor() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            return cu instanceof J.CompilationUnit ? this.visitCompilationUnit((J.CompilationUnit)cu, ctx) : cu;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
            J varDecls = super.visitVariableDeclarations(multiVariable, executionContext);
            TypeTree varDeclsTypeExpression = ((J.VariableDeclarations)varDecls).getTypeExpression();
            if (((J.VariableDeclarations)varDecls).getVariables().size() == 1 && ((J.VariableDeclarations)varDecls).getVariables().get(0).getInitializer() != null && ((J.VariableDeclarations)varDecls).getTypeExpression() instanceof J.ParameterizedType) {
                varDecls = ((J.VariableDeclarations)varDecls).withVariables(ListUtils.map(((J.VariableDeclarations)varDecls).getVariables(), nv -> {
                    if (nv.getInitializer() instanceof J.NewClass) {
                        nv = nv.withInitializer(this.maybeRemoveParams(this.parameterizedTypes((J.ParameterizedType)varDeclsTypeExpression), (J.NewClass)nv.getInitializer()));
                    }
                    return nv;
                }));
            }
            return varDecls;
        }

        @Override
        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext executionContext) {
            J asgn = super.visitAssignment(assignment, executionContext);
            if (((J.Assignment)asgn).getAssignment() instanceof J.NewClass) {
                JavaType.Parameterized assignmentType = TypeUtils.asParameterized(((J.Assignment)asgn).getType());
                J.NewClass nc = (J.NewClass)((J.Assignment)asgn).getAssignment();
                if (assignmentType != null && nc.getClazz() instanceof J.ParameterizedType) {
                    asgn = ((J.Assignment)asgn).withAssignment(this.maybeRemoveParams(assignmentType.getTypeParameters(), nc));
                }
            }
            return asgn;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (this.isAParameter()) {
                return method;
            }
            J mi = super.visitMethodInvocation(method, executionContext);
            JavaType.Method methodType = ((J.MethodInvocation)mi).getMethodType();
            if (methodType != null) {
                mi = ((J.MethodInvocation)mi).withArguments(ListUtils.map(((J.MethodInvocation)mi).getArguments(), (i, arg) -> {
                    JavaType.Parameterized paramType;
                    J.NewClass nc;
                    if (arg instanceof J.NewClass && (nc = (J.NewClass)arg).getBody() == null && !methodType.getParameterTypes().isEmpty() && (paramType = TypeUtils.asParameterized(this.getMethodParamType(methodType, (int)i))) != null && nc.getClazz() instanceof J.ParameterizedType) {
                        return this.maybeRemoveParams(paramType.getTypeParameters(), nc);
                    }
                    return arg;
                }));
            }
            return mi;
        }

        private JavaType getMethodParamType(JavaType.Method methodType, int paramIndex) {
            if (methodType.hasFlags(Flag.Varargs) && paramIndex >= methodType.getParameterTypes().size() - 1) {
                return ((JavaType.Array)methodType.getParameterTypes().get(methodType.getParameterTypes().size() - 1)).getElemType();
            }
            return methodType.getParameterTypes().get(paramIndex);
        }

        @Override
        public J.Return visitReturn(J.Return _return, ExecutionContext executionContext) {
            J.MethodDeclaration md;
            J parentBlock;
            J.NewClass returnExpNewClass;
            J rtn = super.visitReturn(_return, executionContext);
            J.NewClass newClass = returnExpNewClass = ((J.Return)rtn).getExpression() instanceof J.NewClass ? (J.NewClass)((J.Return)rtn).getExpression() : null;
            if (returnExpNewClass != null && returnExpNewClass.getBody() == null && returnExpNewClass.getClazz() instanceof J.ParameterizedType && (parentBlock = (J)this.getCursor().dropParentUntil(v -> v instanceof J.MethodDeclaration || v instanceof J.Lambda).getValue()) instanceof J.MethodDeclaration && (md = (J.MethodDeclaration)parentBlock).getReturnTypeExpression() instanceof J.ParameterizedType) {
                rtn = ((J.Return)rtn).withExpression(this.maybeRemoveParams(this.parameterizedTypes((J.ParameterizedType)md.getReturnTypeExpression()), returnExpNewClass));
            }
            return rtn;
        }

        @Nullable
        private List<JavaType> parameterizedTypes(J.ParameterizedType parameterizedType) {
            if (parameterizedType.getTypeParameters() == null) {
                return null;
            }
            ArrayList<JavaType> types = new ArrayList<JavaType>(parameterizedType.getTypeParameters().size());
            for (Expression typeParameter : parameterizedType.getTypeParameters()) {
                types.add(typeParameter.getType());
            }
            return types;
        }

        private J.NewClass maybeRemoveParams(@Nullable List<JavaType> paramTypes, J.NewClass newClass) {
            J.ParameterizedType newClassType;
            if (paramTypes != null && newClass.getBody() == null && newClass.getClazz() instanceof J.ParameterizedType && (newClassType = (J.ParameterizedType)newClass.getClazz()).getTypeParameters() != null) {
                if (paramTypes.size() != newClassType.getTypeParameters().size()) {
                    return newClass;
                }
                for (int i = 0; i < paramTypes.size(); ++i) {
                    if (TypeUtils.isAssignableTo(paramTypes.get(i), newClassType.getTypeParameters().get(i).getType())) continue;
                    return newClass;
                }
                newClassType.getTypeParameters().stream().map(e -> TypeUtils.asFullyQualified(e.getType())).forEach(this::maybeRemoveImport);
                newClass = newClass.withClazz(newClassType.withTypeParameters(Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY))));
            }
            return newClass;
        }

        private boolean isAParameter() {
            return this.getCursor().dropParentUntil(p -> p instanceof J.MethodInvocation || p instanceof J.ClassDeclaration || p instanceof J.CompilationUnit || p instanceof J.Block || p == "root").getValue() instanceof J.MethodInvocation;
        }
    }
}

