/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NewStringBuilderBufferWithCharArgument
extends Recipe {
    public String getDisplayName() {
        return "Change `StringBuilder` and `StringBuffer` character constructor argument to `String`";
    }

    public String getDescription() {
        return "Instantiating a `StringBuilder` or a `StringBuffer` with a `Character` results in the `int` representation of the character being used for the initial size.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1317");
    }

    public TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.lang.StringBuilder", true), new UsesType("java.lang.StringBuffer", true)});
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final JavaTemplate toString = JavaTemplate.builder(() -> (this).getCursor(), "String.valueOf(#{any()})").build();

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J nc = super.visitNewClass(newClass, executionContext);
                if (TypeUtils.isOfClassType(((J.NewClass)nc).getType(), "java.lang.StringBuilder") || TypeUtils.isOfClassType(((J.NewClass)nc).getType(), "java.lang.StringBuffer")) {
                    ((J.NewClass)nc).getArguments();
                    if (((J.NewClass)nc).getArguments().get(0).getType() == JavaType.Primitive.Char) {
                        nc = ((J.NewClass)nc).withArguments(ListUtils.mapFirst(((J.NewClass)nc).getArguments(), arg -> {
                            if (arg instanceof J.Literal) {
                                J.Literal l = (J.Literal)arg;
                                if ((l = l.withType(JavaType.buildType("String"))).getValueSource() != null) {
                                    l = l.withValueSource(l.getValueSource().replace("'", "\""));
                                }
                                return l;
                            }
                            return (Expression)arg.withTemplate(this.toString, arg.getCoordinates().replace(), arg);
                        }));
                    }
                }
                return nc;
            }
        };
    }
}

