/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class MultipleVariableDeclarationsVisitor
extends JavaIsoVisitor<ExecutionContext> {
    @Override
    public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
        J b = super.visitBlock(block, ctx);
        return ((J.Block)b).withStatements(ListUtils.flatMap(((J.Block)b).getStatements(), statement -> {
            if (!(statement instanceof J.VariableDeclarations)) {
                return statement;
            }
            J.VariableDeclarations mv = (J.VariableDeclarations)statement;
            if (mv.getVariables().size() <= 1) {
                return mv;
            }
            ArrayList<J.VariableDeclarations> newDecls = new ArrayList<J.VariableDeclarations>(mv.getVariables().size());
            for (int i = 0; i < mv.getVariables().size(); ++i) {
                J.VariableDeclarations.NamedVariable nv = mv.getVariables().get(i);
                List dimensions = ListUtils.concatAll(mv.getDimensionsBeforeName(), nv.getDimensionsAfterName());
                nv = nv.withDimensionsAfterName(Collections.emptyList()).withPrefix(Space.EMPTY);
                J.VariableDeclarations vd = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, mv.getLeadingAnnotations(), mv.getModifiers(), mv.getTypeExpression(), mv.getVarargs(), dimensions, Collections.singletonList(JRightPadded.build(nv)));
                if (i == 0) {
                    vd = (J.VariableDeclarations)vd.withComments(mv.getComments()).withPrefix(mv.getPrefix());
                }
                vd = this.autoFormat(vd, ctx, this.getCursor());
                newDecls.add(vd);
            }
            return newDecls;
        }));
    }
}

