/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.ChainStringBuilderAppendCalls;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ReplaceTextBlockWithString
extends Recipe {
    public String getDisplayName() {
        return "Replace text block with regular string";
    }

    public String getDescription() {
        return "Replace text block with a regular multi-line string.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesJavaVersion<ExecutionContext>(13);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ReplaceTextBlockWithStringVisitor();
    }

    private static class ReplaceTextBlockWithStringVisitor
    extends JavaVisitor<ExecutionContext> {
        private ReplaceTextBlockWithStringVisitor() {
        }

        @Override
        public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
            if (literal.getType() == JavaType.Primitive.String && literal.getValue() != null && literal.getValueSource() != null && literal.getValueSource().startsWith("\"\"\"")) {
                String[] lines = ((String)literal.getValue()).split("\n", -1);
                boolean lastLineIsEmpty = lines[lines.length - 1].isEmpty();
                int n = lastLineIsEmpty && lines.length == 1 ? 1 : lines.length - 1;
                int i = 0;
                while (i < n) {
                    int n2 = i++;
                    lines[n2] = lines[n2] + "\\n";
                }
                int linesNumber = !lastLineIsEmpty || lines.length == 1 ? lines.length : lines.length - 1;
                Expression[] literals = new Expression[linesNumber];
                literals[0] = this.toLiteral(lines[0]).withPrefix(literal.getPrefix());
                for (int i2 = 1; i2 < linesNumber; ++i2) {
                    literals[i2] = this.toLiteral(lines[i2]).withPrefix(Space.build("\n", Collections.emptyList()));
                }
                return this.autoFormat(ChainStringBuilderAppendCalls.additiveExpression(literals), ctx);
            }
            return literal;
        }

        private J.Literal toLiteral(String str) {
            return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, str, this.quote(str), Collections.emptyList(), JavaType.Primitive.String);
        }

        private String quote(String str) {
            return "\"" + str.replace("\"", "\\\"") + "\"";
        }
    }
}

