/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.internal.csv;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.openrewrite.java.dataflow.internal.csv.Mergeable;

public class CsvLoader {
    public static <R extends Mergeable<R>, E> R loadFromFile(String csvFileName, R emptyModel, Function<Iterable<E>, R> merger, Function<String[], E> csvMapper) {
        AtomicReference model = new AtomicReference(emptyModel);
        try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{"data-flow"}).enableMemoryMapping().scan();){
            scanResult.getResourcesWithLeafName(csvFileName).forEachInputStreamIgnoringIOException((res, input) -> model.set(((Mergeable)model.get()).merge(CsvLoader.loadCsv(input, res.getURI(), merger, csvMapper))));
        }
        return model.get();
    }

    private static <R extends Mergeable<R>, E> R loadCsv(InputStream input, URI source, Function<Iterable<E>, R> merger, Function<String[], E> csvMapper) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            ArrayList<E> models = new ArrayList<E>();
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] tokens = CsvLoader.parseLine(line);
                models.add(csvMapper.apply(tokens));
            }
            return (R)((Mergeable)merger.apply(models));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read data-flow values from " + source, e);
        }
    }

    private static String[] parseLine(String line) {
        if (line.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ',') {
                result.add("");
                continue;
            }
            int valueStart = i;
            char stopAt = ',';
            if (line.charAt(i) == '\"') {
                valueStart = ++i;
                stopAt = '\"';
            }
            while (i < line.length() && line.charAt(i) != stopAt) {
                ++i;
            }
            result.add(line.substring(valueStart, i));
            if (stopAt != '\"') continue;
            ++i;
        }
        return result.toArray(new String[0]);
    }
}

