/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@Incubating(since="7.24.0")
public class FlowGraph {
    private final Cursor cursor;
    private List<FlowGraph> edges = Collections.emptyList();

    @CheckReturnValue
    FlowGraph addEdge(Cursor cursor) {
        if (this.edges.isEmpty()) {
            this.edges = new ArrayList<FlowGraph>(2);
        }
        FlowGraph edge = new FlowGraph(cursor);
        this.edges.add(edge);
        return edge;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public List<FlowGraph> getEdges() {
        return this.edges;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowGraph)) {
            return false;
        }
        FlowGraph other = (FlowGraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        List<FlowGraph> this$edges = this.getEdges();
        List<FlowGraph> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FlowGraph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        List<FlowGraph> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "FlowGraph(cursor=" + this.getCursor() + ", edges=" + this.getEdges() + ")";
    }

    protected FlowGraph(Cursor cursor) {
        this.cursor = cursor;
    }

    void setEdges(List<FlowGraph> edges) {
        this.edges = edges;
    }
}

