/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.ChainStringBuilderAppendCalls;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public class ReplaceStringBuilderWithString
extends Recipe {
    private static final MethodMatcher STRING_BUILDER_APPEND = new MethodMatcher("java.lang.StringBuilder append(String)");
    private static final MethodMatcher STRING_BUILDER_TO_STRING = new MethodMatcher("java.lang.StringBuilder toString()");
    private static J.Parentheses parenthesesTemplate = null;

    public String getDisplayName() {
        return "Replace StringBuilder.append() with String";
    }

    public String getDescription() {
        return "Replace StringBuilder.append() with String if you are only concatenating a small number of strings and the code is simple and easy to read, as the compiler can optimize simple string concatenation expressions into a single String object, which can be more efficient than using StringBuilder.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(STRING_BUILDER_APPEND);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
                if (STRING_BUILDER_TO_STRING.matches(method)) {
                    ArrayList methodCallsChain = new ArrayList();
                    ArrayList<Expression> arguments = new ArrayList<Expression>();
                    boolean isFlattenable = ReplaceStringBuilderWithString.flatMethodInvocationChain(method, methodCallsChain, arguments);
                    if (!isFlattenable) {
                        return m;
                    }
                    Collections.reverse(arguments);
                    J.Parentheses additive = (J.Parentheses)ChainStringBuilderAppendCalls.additiveExpression(arguments).withPrefix(method.getPrefix());
                    if (this.isAMethodSelect(method)) {
                        additive = ReplaceStringBuilderWithString.wrapExpression(additive);
                    }
                    return additive;
                }
                return m;
            }

            private boolean isAMethodSelect(J.MethodInvocation method) {
                Cursor parent = this.getCursor().getParent(2);
                if (parent == null || !(parent.getValue() instanceof J.MethodInvocation)) {
                    return false;
                }
                return ((J.MethodInvocation)parent.getValue()).getSelect() == method;
            }
        };
    }

    private static boolean flatMethodInvocationChain(J.MethodInvocation method, List<Expression> methodChain, List<Expression> arguments) {
        Expression select = method.getSelect();
        while (select != null) {
            methodChain.add(select);
            if (!(select instanceof J.MethodInvocation)) break;
            J.MethodInvocation selectMethod = (J.MethodInvocation)select;
            select = selectMethod.getSelect();
            if (!STRING_BUILDER_APPEND.matches(selectMethod)) {
                return false;
            }
            List<Expression> args = selectMethod.getArguments();
            if (args.size() != 1) {
                return false;
            }
            Expression arg = args.get(0);
            if (arg instanceof J.Identifier || arg instanceof J.Literal || arg instanceof J.MethodInvocation) {
                arguments.add(arg);
                continue;
            }
            return false;
        }
        return select instanceof J.NewClass && TypeUtils.isOfClassType(((J.NewClass)select).getClazz().getType(), "java.lang.StringBuilder");
    }

    public static J.Parentheses getParenthesesTemplate() {
        if (parenthesesTemplate == null) {
            String simpleParentheseCode = " class B { void foo() { (\"A\" + \"B\").length(); } } ";
            List<J.CompilationUnit> cus = JavaParser.fromJavaVersion().build().parse(simpleParentheseCode);
            parenthesesTemplate = (J.Parentheses)((List)new JavaIsoVisitor<List<J.Parentheses>>(){

                @Override
                public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, List<J.Parentheses> parentheses) {
                    parentheses.add(parens);
                    return parens;
                }
            }.reduce(cus.get(0), new ArrayList(1))).get(0);
        }
        return parenthesesTemplate;
    }

    public static <T extends J> J.Parentheses<T> wrapExpression(Expression exp) {
        return ReplaceStringBuilderWithString.getParenthesesTemplate().withTree(exp);
    }
}

