/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParserExecutionContextView;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

public interface JavaParser
extends Parser<J.CompilationUnit> {
    public static final String SKIP_SOURCE_SET_TYPE_GENERATION = "org.openrewrite.java.skipSourceSetTypeGeneration";

    public static List<Path> runtimeClasspath() {
        return new ClassGraph().disableNestedJarScanning().getClasspathURIs().stream().map(Paths::get).collect(Collectors.toList());
    }

    public static List<Path> dependenciesFromClasspath(String ... artifactNames) {
        List runtimeClasspath = new ClassGraph().getClasspathURIs();
        ArrayList<Path> artifacts = new ArrayList<Path>(artifactNames.length);
        ArrayList<String> missingArtifactNames = new ArrayList<String>(artifactNames.length);
        for (String artifactName : artifactNames) {
            Pattern jarPattern = Pattern.compile(artifactName + "-.*?\\.jar$");
            Pattern explodedPattern = Pattern.compile("/" + artifactName + "/");
            boolean lacking = true;
            for (URI cpEntry : runtimeClasspath) {
                String cpEntryString = cpEntry.toString();
                if (!jarPattern.matcher(cpEntryString).find() && (!explodedPattern.matcher(cpEntryString).find() || !Paths.get(cpEntry).toFile().isDirectory())) continue;
                artifacts.add(Paths.get(cpEntry));
                lacking = false;
            }
            if (!lacking) continue;
            missingArtifactNames.add(artifactName);
        }
        if (!missingArtifactNames.isEmpty()) {
            throw new IllegalArgumentException("Unable to find runtime dependencies beginning with: " + missingArtifactNames.stream().map(a -> "'" + a + "'").sorted().collect(Collectors.joining(", ")));
        }
        return artifacts;
    }

    public static List<Path> dependenciesFromResources(ExecutionContext ctx, String ... artifactNamesWithVersions) {
        Class caller;
        ArrayList<Path> artifacts = new ArrayList<Path>(artifactNamesWithVersions.length);
        LinkedHashSet<String> missingArtifactNames = new LinkedHashSet<String>(artifactNamesWithVersions.length);
        File resourceTarget = JavaParserExecutionContextView.view(ctx).getParserClasspathDownloadTarget();
        block9: for (String artifactName : artifactNamesWithVersions) {
            Pattern jarPattern = Pattern.compile(artifactName + "-?.*\\.jar$");
            File[] extracted = resourceTarget.listFiles();
            if (extracted != null) {
                for (File file : extracted) {
                    if (!jarPattern.matcher(file.getName()).find()) continue;
                    artifacts.add(file.toPath());
                    continue block9;
                }
            }
            missingArtifactNames.add(artifactName);
        }
        if (missingArtifactNames.isEmpty()) {
            return artifacts;
        }
        try {
            Class<?> options = Class.forName("java.lang.StackWalker$Option");
            Object retainOption = options.getDeclaredField("RETAIN_CLASS_REFERENCE").get(null);
            Class<?> walkerClass = Class.forName("java.lang.StackWalker");
            Method getInstance = walkerClass.getDeclaredMethod("getInstance", options);
            Object walker = getInstance.invoke(null, retainOption);
            Method getDeclaringClass = Class.forName("java.lang.StackWalker$StackFrame").getDeclaredMethod("getDeclaringClass", new Class[0]);
            caller = (Class)walkerClass.getMethod("walk", Function.class).invoke(walker, s -> s.map(f -> {
                try {
                    return (Class)getDeclaringClass.invoke(f, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }).filter(c -> !c.getName().equals(JavaParser.class.getName()) && !c.getName().equals(Builder.class.getName())).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find caller of JavaParser.dependenciesFromResources(..)")));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            caller = JavaParser.class;
        }
        try (ScanResult result = new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite/classpath"}).addClassLoader(caller.getClassLoader()).scan();){
            ResourceList resources = result.getResourcesWithExtension(".jar");
            block11: for (String artifactName : new ArrayList(missingArtifactNames)) {
                Pattern jarPattern = Pattern.compile(artifactName + "-?.*\\.jar$");
                for (Resource resource : resources) {
                    if (!jarPattern.matcher(resource.getPath()).find()) continue;
                    try {
                        Path artifact = resourceTarget.toPath().resolve(Paths.get(resource.getPath(), new String[0]).getFileName());
                        Files.copy(Objects.requireNonNull(caller.getResourceAsStream("/" + resource.getPath())), artifact, new CopyOption[0]);
                        missingArtifactNames.remove(artifactName);
                        artifacts.add(artifact);
                        continue block11;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            if (!missingArtifactNames.isEmpty()) {
                throw new IllegalArgumentException("Unable to find classpath resource dependencies beginning with: " + missingArtifactNames.stream().map(a -> "'" + a + "'").sorted().collect(Collectors.joining(", ", "", ".\n")) + "The caller is of type " + (caller == null ? "NO CALLER IDENTIFIED" : caller.getName()) + ".\nThe resources resolvable from the caller's classpath are: " + resources.stream().map(Resource::getPath).sorted().collect(Collectors.joining(", ")));
            }
        }
        return artifacts;
    }

    public static Builder<? extends JavaParser, ?> fromJavaVersion() {
        String[] versionParts = System.getProperty("java.version").split("\\.");
        int version = Integer.parseInt(versionParts[0]);
        if (version == 1) {
            version = 8;
        }
        if (version >= 17) {
            try {
                Builder javaParser = (Builder)((Object)Class.forName("org.openrewrite.java.Java17Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]));
                return javaParser;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version >= 11) {
            try {
                Builder javaParser = (Builder)((Object)Class.forName("org.openrewrite.java.Java11Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]));
                return javaParser;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Builder javaParser = (Builder)((Object)Class.forName("org.openrewrite.java.Java8Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]));
            return javaParser;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create a Java parser instance. `rewrite-java-8`, `rewrite-java-11`, or `rewrite-java-17` must be on the classpath.", e);
        }
    }

    default public List<J.CompilationUnit> parse(ExecutionContext ctx, String ... sources) {
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> new Parser.Input(this.sourcePathFromSourceText(Paths.get("", new String[0]), (String)sourceFile), null, () -> new ByteArrayInputStream(sourceFile.getBytes(this.getCharset(ctx))), true)).collect(Collectors.toList()), null, ctx);
    }

    default public List<J.CompilationUnit> parse(String ... sources) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        return this.parse((ExecutionContext)ctx, sources);
    }

    default public boolean accept(Path path) {
        return path.toString().endsWith(".java");
    }

    public JavaParser reset();

    public JavaParser reset(Collection<URI> var1);

    public void setClasspath(Collection<Path> var1);

    public void setSourceSet(String var1);

    public JavaSourceSet getSourceSet(ExecutionContext var1);

    default public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum|record)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        Matcher packageMatcher = packagePattern.matcher(sourceCode);
        String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
        String className = Optional.ofNullable(simpleName.apply(sourceCode)).orElse(Long.toString(System.nanoTime())) + ".java";
        return prefix.resolve(Paths.get(pkg + className, new String[0]));
    }

    public static abstract class Builder<P extends JavaParser, B extends Builder<P, B>>
    extends Parser.Builder {
        protected Collection<Path> classpath = Collections.emptyList();
        protected Collection<byte[]> classBytesClasspath = Collections.emptyList();
        protected JavaTypeCache javaTypeCache = new JavaTypeCache();
        @Nullable
        protected Collection<Parser.Input> dependsOn;
        protected Charset charset = Charset.defaultCharset();
        protected boolean logCompilationWarningsAndErrors = false;
        protected final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder() {
            super(J.CompilationUnit.class);
        }

        public B logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return (B)((Object)this);
        }

        public B typeCache(JavaTypeCache javaTypeCache) {
            this.javaTypeCache = javaTypeCache;
            return (B)((Object)this);
        }

        public B charset(Charset charset) {
            this.charset = charset;
            return (B)((Object)this);
        }

        public B dependsOn(Collection<Parser.Input> inputs) {
            this.dependsOn = inputs;
            return (B)((Object)this);
        }

        public B dependsOn(String ... inputsAsStrings) {
            this.dependsOn = Arrays.stream(inputsAsStrings).map(Parser.Input::fromString).collect(Collectors.toList());
            return (B)((Object)this);
        }

        public B classpath(Collection<Path> classpath) {
            this.classpath = classpath;
            return (B)((Object)this);
        }

        public B classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath(classpath);
            return (B)((Object)this);
        }

        public B classpathFromResources(ExecutionContext ctx, String ... classpath) {
            this.classpath = JavaParser.dependenciesFromResources(ctx, classpath);
            return (B)((Object)this);
        }

        public B classpath(byte[] ... classpath) {
            this.classBytesClasspath = Arrays.asList(classpath);
            return (B)((Object)this);
        }

        public B styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return (B)((Object)this);
        }

        public abstract P build();

        public String getDslName() {
            return "java";
        }

        public Builder<P, B> clone() {
            Builder clone = (Builder)super.clone();
            clone.javaTypeCache = this.javaTypeCache.clone();
            return clone;
        }
    }
}

