/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Optional;
import java.util.Set;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class DoesNotUseRewriteSkip
extends Recipe {
    public String getDisplayName() {
        return "Uses `@RewriteSkip` annotation";
    }

    public String getDescription() {
        return "The annotation provides a mechanism to skip a whole source file from consideration";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Applicability.not((TreeVisitor)new UsesRewriteSkipVisitor());
    }

    private static class UsesRewriteSkipVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private UsesRewriteSkipVisitor() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            JavaSourceFile c = cu;
            if (c.getPackageDeclaration() != null) {
                Set<J.Annotation> skips = FindAnnotations.find(c.getPackageDeclaration(), "@org.openrewrite.java.RewriteSkip");
                for (J.Annotation skip : skips) {
                    c = c.withPackageDeclaration((J.Package)this.visit(c.getPackageDeclaration(), ctx, this.getCursor()));
                    if (skip.getArguments() != null && !skip.getArguments().isEmpty()) continue;
                    c = (JavaSourceFile)SearchResult.found((Tree)c);
                }
            }
            return c;
        }

        @Override
        public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
            J.Literal l = literal;
            if (literal.getType() == JavaType.Primitive.String) {
                assert (literal.getValue() != null);
                Optional parentRecipe = ctx.getParentRecipe();
                if (parentRecipe.isPresent() && literal.getValue().toString().equals(((Recipe)parentRecipe.get()).getClass().getName())) {
                    return (J.Literal)SearchResult.found((Tree)l);
                }
            }
            return l;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            Optional parentRecipe;
            J.FieldAccess f = fieldAccess;
            if (f.getSimpleName().equals("class") && (parentRecipe = ctx.getParentRecipe()).isPresent() && TypeUtils.isOfClassType(f.getTarget().getType(), ((Recipe)parentRecipe.get()).getClass().getName())) {
                return (J.FieldAccess)SearchResult.found((Tree)f);
            }
            return f;
        }
    }
}

