/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public class SourceSpecTextBlockIndentation
extends Recipe {
    public String getDisplayName() {
        return "Minimal indentation for `SourceSpecs` text blocks";
    }

    public String getDescription() {
        return "Text blocks that assert before and after source code should have minimal indentation.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final Pattern endTextBlockOnOwnLine = Pattern.compile("\\s+\"\"\"\\s*$");

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (method.getMethodType() != null && TypeUtils.isOfClassType(method.getMethodType().getReturnType(), "org.openrewrite.test.SourceSpecs")) {
                    return method.withArguments(ListUtils.map(method.getArguments(), argument -> {
                        J.Literal source;
                        if (TypeUtils.isString(argument.getType()) && argument instanceof J.Literal && (source = (J.Literal)argument).getValueSource() != null && source.getValueSource().startsWith("\"\"\"") && this.endTextBlockOnOwnLine.matcher(source.getValueSource()).find()) {
                            String[] lines = source.getValueSource().split("\n");
                            int[] indentations = new int[lines.length - 1];
                            boolean[] nonSpaceCharacter = new boolean[lines.length - 1];
                            Arrays.fill(indentations, 0);
                            Arrays.fill(nonSpaceCharacter, false);
                            block0: for (int i = 1; i < lines.length; ++i) {
                                String line = lines[i];
                                for (int j = 0; j < line.length(); ++j) {
                                    if (line.charAt(j) != ' ') {
                                        nonSpaceCharacter[i - 1] = true;
                                        continue block0;
                                    }
                                    int n = i - 1;
                                    indentations[n] = indentations[n] + 1;
                                }
                            }
                            int expectedIndent = indentations[indentations.length - 1];
                            if (indentations.length >= 2 && nonSpaceCharacter[0] && nonSpaceCharacter[indentations.length - 2] && indentations[0] == indentations[indentations.length - 2] && indentations[0] > expectedIndent) {
                                for (int i = 0; i < indentations.length - 1; ++i) {
                                    if (!nonSpaceCharacter[i] || indentations[i] >= indentations[0]) continue;
                                    return argument;
                                }
                                int marginTrim = indentations[0] - expectedIndent;
                                StringJoiner fixedSource = new StringJoiner("\n");
                                for (int i = 0; i < lines.length; ++i) {
                                    String line = lines[i];
                                    if (i == 0 || i == lines.length - 1 || indentations[i - 1] < expectedIndent) {
                                        fixedSource.add(line);
                                        continue;
                                    }
                                    fixedSource.add(line.substring(marginTrim));
                                }
                                return source.withValueSource(fixedSource.toString());
                            }
                        }
                        return argument;
                    }));
                }
                return super.visitMethodInvocation(method, ctx);
            }
        };
    }
}

