/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class MethodNameCasing
extends Recipe {
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false, example="true")
    @Nullable
    private final Boolean includeTestSources;
    @Option(displayName="Rename public methods", description="Changes are not applied to public methods unless specified.", required=false, example="false")
    @Nullable
    private final Boolean renamePublicMethods;

    public String getDisplayName() {
        return "Method name casing";
    }

    public String getDescription() {
        return "Method names should comply with a naming convention.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-100");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern standardMethodName = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
        final Pattern snakeCase = Pattern.compile("^[a-zA-Z0-9]+_\\w+$");
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                if (sourceSet.isPresent() && (Boolean.TRUE.equals(MethodNameCasing.this.includeTestSources) || "main".equals(((JavaSourceSet)sourceSet.get()).getName()))) {
                    return super.visitJavaSourceFile(cu, executionContext);
                }
                return cu;
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (enclosingClass == null || enclosingClass.getKind() != J.ClassDeclaration.Kind.Type.Class) {
                    return method;
                }
                if (!(!this.containsValidModifiers(method) || method.getMethodType() == null || enclosingClass.getType() == null || method.isConstructor() || TypeUtils.isOverride(method.getMethodType()) || standardMethodName.matcher(method.getSimpleName()).matches() || method.getSimpleName().startsWith("_"))) {
                    String toName;
                    StringBuilder standardized = new StringBuilder();
                    String normalized = VariableNameUtils.normalizeName(method.getSimpleName());
                    char[] name = normalized.toCharArray();
                    if (snakeCase.matcher(normalized).matches()) {
                        standardized.append(NameCaseConvention.format((NameCaseConvention)NameCaseConvention.LOWER_CAMEL, (String)normalized));
                    } else {
                        for (int i = 0; i < name.length; ++i) {
                            char c = name[i];
                            if (i == 0) {
                                if (c == '$' || c == '_') continue;
                                standardized.append(Character.toLowerCase(c));
                                continue;
                            }
                            if (!Character.isLetterOrDigit(c)) {
                                while (!(i >= name.length || Character.isLetterOrDigit(name[i]) && name[i] <= 'z')) {
                                    ++i;
                                }
                                if (i >= name.length) continue;
                                standardized.append(Character.toUpperCase(name[i]));
                                continue;
                            }
                            standardized.append(c);
                        }
                    }
                    if (!(StringUtils.isBlank((String)standardized.toString()) || this.methodExists(method.getMethodType(), standardized.toString()) || StringUtils.isNumeric((String)(toName = standardized.toString())))) {
                        MethodNameCasing.this.doNext(new ChangeMethodName(MethodMatcher.methodPattern(method), standardized.toString(), true, false));
                    }
                }
                return super.visitMethodDeclaration(method, executionContext);
            }

            private boolean containsValidModifiers(J.MethodDeclaration method) {
                return !method.hasModifier(J.Modifier.Type.Public) || Boolean.TRUE.equals(MethodNameCasing.this.renamePublicMethods);
            }

            private boolean methodExists(JavaType.Method method, String newName) {
                return TypeUtils.findDeclaredMethod(method.getDeclaringType(), newName, method.getParameterTypes()).orElse(null) != null;
            }
        };
    }

    public MethodNameCasing(@Nullable Boolean includeTestSources, @Nullable Boolean renamePublicMethods) {
        this.includeTestSources = includeTestSources;
        this.renamePublicMethods = renamePublicMethods;
    }

    @Nullable
    public Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    @Nullable
    public Boolean getRenamePublicMethods() {
        return this.renamePublicMethods;
    }

    @NonNull
    public String toString() {
        return "MethodNameCasing(includeTestSources=" + this.getIncludeTestSources() + ", renamePublicMethods=" + this.getRenamePublicMethods() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodNameCasing)) {
            return false;
        }
        MethodNameCasing other = (MethodNameCasing)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        if (this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources)) {
            return false;
        }
        Boolean this$renamePublicMethods = this.getRenamePublicMethods();
        Boolean other$renamePublicMethods = other.getRenamePublicMethods();
        return !(this$renamePublicMethods == null ? other$renamePublicMethods != null : !((Object)this$renamePublicMethods).equals(other$renamePublicMethods));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MethodNameCasing;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        Boolean $renamePublicMethods = this.getRenamePublicMethods();
        result = result * 59 + ($renamePublicMethods == null ? 43 : ((Object)$renamePublicMethods).hashCode());
        return result;
    }
}

