/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.JavaTemplateJavaExtension;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.template.SourceTemplate;

public class JavaTemplate
implements SourceTemplate<J, JavaCoordinates> {
    private final Supplier<Cursor> parentScopeGetter;
    private final String code;
    private final int parameterCount;
    private final Consumer<String> onAfterVariableSubstitution;
    private final JavaTemplateParser templateParser;

    private JavaTemplate(Supplier<Cursor> parentScopeGetter, Supplier<JavaParser> parser, String code, Set<String> imports, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.parentScopeGetter = parentScopeGetter;
        this.code = code;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.parameterCount = StringUtils.countOccurrences((String)code, (String)"#{");
        this.templateParser = new JavaTemplateParser(parser, onAfterVariableSubstitution, onBeforeParseTemplate, imports);
    }

    public <J2 extends J> J2 withTemplate(final Tree changing, JavaCoordinates coordinates, Object[] parameters) {
        if (parameters.length != this.parameterCount) {
            throw new IllegalArgumentException("This template requires " + this.parameterCount + " parameters.");
        }
        Substitutions substitutions = new Substitutions(this.code, parameters);
        String substitutedTemplate = substitutions.substitute();
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        J insertionPoint = coordinates.getTree();
        Space.Location loc = coordinates.getSpaceLocation();
        JavaCoordinates.Mode mode = coordinates.getMode();
        final AtomicReference<Cursor> parentCursorRef = new AtomicReference<Cursor>();
        Cursor parentScope = this.parentScopeGetter.get();
        if (!(parentScope.getValue() instanceof J)) {
            parentScope = parentScope.getParentTreeCursor();
        }
        new JavaIsoVisitor<Integer>(){

            @Nullable
            public J visit(@Nullable Tree tree, Integer integer) {
                if (tree != null && tree.isScope(changing)) {
                    Cursor cursor = this.getCursor();
                    if (!(cursor.getValue() instanceof J)) {
                        cursor = cursor.getParentTreeCursor();
                    }
                    parentCursorRef.set(cursor);
                    return (J)tree;
                }
                return (J)super.visit(tree, (Object)integer);
            }
        }.visit((Tree)parentScope.getValue(), 0, parentScope.getParentOrThrow());
        Cursor parentCursor = (Cursor)parentCursorRef.get();
        return (J2)((J)new JavaTemplateJavaExtension(this.templateParser, substitutions, substitutedTemplate, coordinates, parentCursorRef, parentScope).getMixin().visit(changing, (Object)0, parentCursor));
    }

    public static Builder builder(Supplier<Cursor> parentScope, String code) {
        return new Builder(parentScope, code);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F0 f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F1<?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F2<?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F3<?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F4<?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F5<?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F6<?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F7<?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F8<?, ?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F9<?, ?, ?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static class Builder {
        private final Supplier<Cursor> parentScope;
        private final String code;
        private final Set<String> imports = new HashSet<String>();
        private Supplier<JavaParser> javaParser = () -> JavaParser.fromJavaVersion().build();
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(Supplier<Cursor> parentScope, String code) {
            this.parentScope = parentScope;
            this.code = code.trim();
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                if (!this.shouldAddImport(typeName)) continue;
                this.imports.add("import " + typeName + ";\n");
            }
            return this;
        }

        public Builder staticImports(String ... fullyQualifiedMemberTypeNames) {
            for (String typeName : fullyQualifiedMemberTypeNames) {
                if (!this.shouldAddImport(typeName)) continue;
                this.imports.add("import static " + typeName + ";\n");
            }
            return this;
        }

        private boolean shouldAddImport(String typeName) {
            if (StringUtils.isBlank((String)typeName)) {
                return false;
            }
            if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
            }
            if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
            }
            return true;
        }

        public Builder javaParser(Supplier<JavaParser> javaParser) {
            this.javaParser = javaParser;
            return this;
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public JavaTemplate build() {
            return new JavaTemplate(this.parentScope, this.javaParser, this.code, this.imports, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }

    static final class PatternBuilder {
        private final String name;

        public Builder build(JavaVisitor<?> owner) {
            try {
                Class<?> templateClass = Class.forName(((Object)owner).getClass().getName() + "_" + this.name);
                Method getTemplate = templateClass.getDeclaredMethod("getTemplate", JavaVisitor.class);
                return (Builder)getTemplate.invoke(null, new Object[]{owner});
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public PatternBuilder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatternBuilder)) {
                return false;
            }
            PatternBuilder other = (PatternBuilder)o;
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplate.PatternBuilder(name=" + this.getName() + ")";
        }
    }

    public static interface F10<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8, P9 var9, P10 var10) throws Exception;
    }

    public static interface F9<P1, P2, P3, P4, P5, P6, P7, P8, P9> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8, P9 var9) throws Exception;
    }

    public static interface F8<P1, P2, P3, P4, P5, P6, P7, P8> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8) throws Exception;
    }

    public static interface F7<P1, P2, P3, P4, P5, P6, P7> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7) throws Exception;
    }

    public static interface F6<P1, P2, P3, P4, P5, P6> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6) throws Exception;
    }

    public static interface F5<P1, P2, P3, P4, P5> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5) throws Exception;
    }

    public static interface F4<P1, P2, P3, P4> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4) throws Exception;
    }

    public static interface F3<P1, P2, P3> {
        public void accept(P1 var1, P2 var2, P3 var3) throws Exception;
    }

    public static interface F2<P1, P2> {
        public void accept(P1 var1, P2 var2) throws Exception;
    }

    public static interface F1<P1> {
        public void accept(P1 var1) throws Exception;
    }

    public static interface F0 {
        public void accept() throws Exception;
    }
}

