/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public final class FindLiterals
extends Recipe {
    @Option(displayName="Pattern", description="A regular expression pattern to match literals against.", example="file://")
    private final String pattern;

    public String getDisplayName() {
        return "Find literals";
    }

    public String getDescription() {
        return "Find literals matching a pattern.";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"pattern", (String)"Must be a valid regular expression", (Object)this.pattern, p -> {
            try {
                Pattern.compile(p);
                return true;
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }));
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        final Pattern compiledPattern = Pattern.compile(this.pattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                if (literal.getValueSource() != null) {
                    if (literal.getType() == JavaType.Primitive.String && compiledPattern.matcher(literal.getValueSource().substring(1, literal.getValueSource().length() - 1)).matches()) {
                        return (J.Literal)SearchResult.found((Tree)literal);
                    }
                    if (compiledPattern.matcher(literal.getValueSource()).matches()) {
                        return (J.Literal)SearchResult.found((Tree)literal);
                    }
                }
                return literal;
            }
        };
    }

    public FindLiterals(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    @NonNull
    public String toString() {
        return "FindLiterals(pattern=" + this.getPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindLiterals)) {
            return false;
        }
        FindLiterals other = (FindLiterals)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindLiterals;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }
}

