/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.UnnecessaryParenthesesStyle;
import org.openrewrite.java.tree.JavaSourceFile;

public class UnnecessaryParentheses
extends Recipe {
    public String getDisplayName() {
        return "Remove unnecessary parentheses";
    }

    public String getDescription() {
        return "Removes unnecessary parentheses from code where extra parentheses pairs are redundant.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1110", "RSPEC-1611"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                UnnecessaryParenthesesStyle style = (UnnecessaryParenthesesStyle)((SourceFile)cu).getStyle(UnnecessaryParenthesesStyle.class);
                if (style == null) {
                    style = Checkstyle.unnecessaryParentheses();
                }
                this.doAfterVisit(new UnnecessaryParenthesesVisitor(style));
                return cu;
            }
        };
    }

    public boolean causesAnotherCycle() {
        return true;
    }
}

