/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.cleanup.MultipleVariableDeclarationsVisitor;

public class MultipleVariableDeclarations
extends Recipe {
    public String getDisplayName() {
        return "Multiple variable declarations";
    }

    public String getDescription() {
        return "Places each variable declaration in its own statement and on its own line. Using one variable declaration per line encourages commenting and can increase readability.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1659");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MultipleVariableDeclarationsVisitor();
    }
}

