/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

public class TypeUtils {
    private TypeUtils() {
    }

    public static boolean isString(@Nullable JavaType type) {
        return type == JavaType.Primitive.String || type instanceof JavaType.FullyQualified && "java.lang.String".equals(((JavaType.FullyQualified)type).getFullyQualifiedName());
    }

    public static boolean fullyQualifiedNamesAreEqual(@Nullable String fqn1, @Nullable String fqn2) {
        if (fqn1 != null && fqn2 != null) {
            return fqn1.replace("$", ".").equals(fqn2.replace("$", "."));
        }
        return fqn1 == null && fqn2 == null;
    }

    public static boolean isOfType(@Nullable JavaType type1, @Nullable JavaType type2) {
        if (type1 instanceof JavaType.Unknown || type2 instanceof JavaType.Unknown) {
            return false;
        }
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        if (TypeUtils.isString(type1) && TypeUtils.isString(type2)) {
            return true;
        }
        if (type1 instanceof JavaType.Primitive && type2 instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type1).getKeyword().equals(((JavaType.Primitive)type2).getKeyword());
        }
        if (type1 instanceof JavaType.FullyQualified && type2 instanceof JavaType.FullyQualified && TypeUtils.fullyQualifiedNamesAreEqual(((JavaType.FullyQualified)type1).getFullyQualifiedName(), ((JavaType.FullyQualified)type2).getFullyQualifiedName())) {
            if (type1 instanceof JavaType.Class && type2 instanceof JavaType.Class) {
                return true;
            }
            if (type1 instanceof JavaType.Parameterized && type2 instanceof JavaType.Parameterized) {
                JavaType.Parameterized parameterized1 = (JavaType.Parameterized)type1;
                JavaType.Parameterized parameterized2 = (JavaType.Parameterized)type2;
                if (parameterized1.getTypeParameters().size() == parameterized2.getTypeParameters().size()) {
                    for (int index = 0; index < parameterized1.getTypeParameters().size(); ++index) {
                        if (TypeUtils.isOfType(parameterized1.getTypeParameters().get(index), parameterized2.getTypeParameters().get(index))) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        if (type1 instanceof JavaType.Array && type2 instanceof JavaType.Array) {
            return TypeUtils.isOfType(((JavaType.Array)type1).getElemType(), ((JavaType.Array)type2).getElemType());
        }
        if (type1 instanceof JavaType.GenericTypeVariable && type2 instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable generic1 = (JavaType.GenericTypeVariable)type1;
            JavaType.GenericTypeVariable generic2 = (JavaType.GenericTypeVariable)type2;
            if (generic1.getBounds().size() == generic2.getBounds().size() && generic1.getVariance() == generic2.getVariance()) {
                for (int index = 0; index < generic1.getBounds().size(); ++index) {
                    if (TypeUtils.isOfType(generic1.getBounds().get(index), generic2.getBounds().get(index))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (type1 instanceof JavaType.Method && type2 instanceof JavaType.Method) {
            int index;
            JavaType.Method method1 = (JavaType.Method)type1;
            JavaType.Method method2 = (JavaType.Method)type2;
            if (!(method1.getName().equals(method2.getName()) && method1.getFlags().size() == method2.getFlags().size() && method1.getFlags().containsAll(method2.getFlags()) && TypeUtils.isOfType(method1.getDeclaringType(), method2.getDeclaringType()) && TypeUtils.isOfType(method1.getReturnType(), method2.getReturnType()) && method1.getAnnotations().size() == method2.getAnnotations().size() && method1.getThrownExceptions().size() == method2.getThrownExceptions().size() && method1.getParameterTypes().size() == method2.getParameterTypes().size())) {
                return false;
            }
            for (index = 0; index < method1.getParameterTypes().size(); ++index) {
                if (TypeUtils.isOfType(method1.getParameterTypes().get(index), method2.getParameterTypes().get(index))) continue;
                return false;
            }
            for (index = 0; index < method1.getThrownExceptions().size(); ++index) {
                if (TypeUtils.isOfType(method1.getThrownExceptions().get(index), method2.getThrownExceptions().get(index))) continue;
                return false;
            }
            for (index = 0; index < method1.getAnnotations().size(); ++index) {
                if (TypeUtils.isOfType(method1.getAnnotations().get(index), method2.getAnnotations().get(index))) continue;
                return false;
            }
            return true;
        }
        return type1.equals(type2);
    }

    public static boolean isOfClassType(@Nullable JavaType type, String fqn) {
        if (type instanceof JavaType.FullyQualified) {
            return TypeUtils.fullyQualifiedNamesAreEqual(((JavaType.FullyQualified)type).getFullyQualifiedName(), fqn);
        }
        if (type instanceof JavaType.Variable) {
            return TypeUtils.isOfClassType(((JavaType.Variable)type).getType(), fqn);
        }
        if (type instanceof JavaType.Method) {
            return TypeUtils.isOfClassType(((JavaType.Method)type).getReturnType(), fqn);
        }
        if (type instanceof JavaType.Array) {
            return TypeUtils.isOfClassType(((JavaType.Array)type).getElemType(), fqn);
        }
        if (type instanceof JavaType.Primitive) {
            return type == JavaType.Primitive.fromKeyword(fqn);
        }
        return false;
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from) {
        try {
            if (to instanceof JavaType.Unknown || from instanceof JavaType.Unknown) {
                return false;
            }
            if (to == from) {
                return true;
            }
            if (to instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified toFq = (JavaType.FullyQualified)to;
                return TypeUtils.isAssignableTo(toFq.getFullyQualifiedName(), from);
            }
            if (to instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericTo = (JavaType.GenericTypeVariable)to;
                for (JavaType bound : genericTo.getBounds()) {
                    if (!TypeUtils.isAssignableTo(bound, from)) continue;
                    return true;
                }
            } else {
                if (to instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(((JavaType.Variable)to).getType(), from);
                }
                if (to instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(((JavaType.Method)to).getReturnType(), from);
                }
                if (to instanceof JavaType.Primitive) {
                    if (from instanceof JavaType.FullyQualified) {
                        JavaType.ShallowClass boxed = JavaType.ShallowClass.build(((JavaType.Primitive)to).getClassName());
                        return TypeUtils.isAssignableTo(boxed, from);
                    }
                } else if (to instanceof JavaType.Array && from instanceof JavaType.Array) {
                    return TypeUtils.isAssignableTo(((JavaType.Array)to).getElemType(), ((JavaType.Array)from).getElemType());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isAssignableTo(String to, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                return to.equals(classFrom.getFullyQualifiedName()) || TypeUtils.isAssignableTo(to, (JavaType)classFrom.getSupertype()) || classFrom.getInterfaces().stream().anyMatch(i -> TypeUtils.isAssignableTo(to, (JavaType)i));
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(to, bound)) continue;
                    return true;
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Method)from).getReturnType());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isAssignableTo(Pattern to, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                return to.matcher(classFrom.getFullyQualifiedName()).matches() || TypeUtils.isAssignableTo(to, (JavaType)classFrom.getSupertype()) || classFrom.getInterfaces().stream().anyMatch(i -> TypeUtils.isAssignableTo(to, (JavaType)i));
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(to, bound)) continue;
                    return true;
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Method)from).getReturnType());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Nullable
    public static JavaType.Class asClass(@Nullable JavaType type) {
        return type instanceof JavaType.Class ? (JavaType.Class)type : null;
    }

    @Nullable
    public static JavaType.Parameterized asParameterized(@Nullable JavaType type) {
        return type instanceof JavaType.Parameterized ? (JavaType.Parameterized)type : null;
    }

    @Nullable
    public static JavaType.Array asArray(@Nullable JavaType type) {
        return type instanceof JavaType.Array ? (JavaType.Array)type : null;
    }

    @Nullable
    public static JavaType.GenericTypeVariable asGeneric(@Nullable JavaType type) {
        return type instanceof JavaType.GenericTypeVariable ? (JavaType.GenericTypeVariable)type : null;
    }

    @Nullable
    public static JavaType.Primitive asPrimitive(@Nullable JavaType type) {
        return type instanceof JavaType.Primitive ? (JavaType.Primitive)type : null;
    }

    @Nullable
    public static JavaType.FullyQualified asFullyQualified(@Nullable JavaType type) {
        if (type instanceof JavaType.FullyQualified) {
            if (type == JavaType.Unknown.getInstance()) {
                return null;
            }
            return (JavaType.FullyQualified)type;
        }
        return null;
    }

    public static boolean isOverride(@Nullable JavaType.Method method) {
        return TypeUtils.findOverriddenMethod(method).isPresent();
    }

    public static Optional<JavaType.Method> findOverriddenMethod(@Nullable JavaType.Method method) {
        Optional<JavaType.Method> methodResult;
        block2: {
            JavaType.FullyQualified i;
            if (method == null) {
                return Optional.empty();
            }
            JavaType.FullyQualified dt = method.getDeclaringType();
            List<JavaType> argTypes = method.getParameterTypes();
            methodResult = TypeUtils.findDeclaredMethod(dt.getSupertype(), method.getName(), argTypes);
            if (methodResult.isPresent()) break block2;
            Iterator<JavaType.FullyQualified> iterator = dt.getInterfaces().iterator();
            while (iterator.hasNext() && !(methodResult = TypeUtils.findDeclaredMethod(i = iterator.next(), method.getName(), argTypes)).isPresent()) {
            }
        }
        return methodResult.filter(m -> !m.getFlags().contains((Object)Flag.Private) && !m.getFlags().contains((Object)Flag.Static));
    }

    public static Optional<JavaType.Method> findDeclaredMethod(@Nullable JavaType.FullyQualified clazz, String name, List<JavaType> argumentTypes) {
        if (clazz == null) {
            return Optional.empty();
        }
        for (JavaType.Method method : clazz.getMethods()) {
            if (!TypeUtils.methodHasSignature(clazz, method, name, argumentTypes)) continue;
            return Optional.of(method);
        }
        Optional<JavaType.Method> methodResult = TypeUtils.findDeclaredMethod(clazz.getSupertype(), name, argumentTypes);
        if (methodResult.isPresent()) {
            return methodResult;
        }
        for (JavaType.FullyQualified i : clazz.getInterfaces()) {
            methodResult = TypeUtils.findDeclaredMethod(i, name, argumentTypes);
            if (!methodResult.isPresent()) continue;
            return methodResult;
        }
        return Optional.empty();
    }

    private static boolean methodHasSignature(JavaType.FullyQualified clazz, JavaType.Method m, String name, List<JavaType> argTypes) {
        if (!name.equals(m.getName())) {
            return false;
        }
        List<JavaType> mArgs = m.getParameterTypes();
        if (mArgs.size() != argTypes.size()) {
            return false;
        }
        IdentityHashMap<JavaType, JavaType> parameterMap = new IdentityHashMap<JavaType, JavaType>();
        List<JavaType> declaringTypeParams = m.getDeclaringType().getTypeParameters();
        List<JavaType> typeParameters = clazz.getTypeParameters();
        if (typeParameters.size() != declaringTypeParams.size()) {
            return false;
        }
        for (int j = 0; j < typeParameters.size(); ++j) {
            JavaType typeAttributed = typeParameters.get(j);
            JavaType generic = declaringTypeParams.get(j);
            parameterMap.put(generic, typeAttributed);
        }
        for (int i = 0; i < mArgs.size(); ++i) {
            JavaType actual;
            JavaType declared = mArgs.get(i);
            if (TypeUtils.isOfType(declared, actual = argTypes.get(i)) || parameterMap.get(declared) == actual) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals(@Nullable List<? extends JavaType> ts1, @Nullable List<? extends JavaType> ts2) {
        if (ts1 == null || ts2 == null) {
            return ts1 == null && ts2 == null;
        }
        if (ts1.size() != ts2.size()) {
            return false;
        }
        for (int i = 0; i < ts1.size(); ++i) {
            JavaType t1 = ts1.get(i);
            JavaType t2 = ts2.get(i);
            if (!(t1 == null ? t2 != null : !TypeUtils.deepEquals(t1, t2))) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals(@Nullable JavaType t, @Nullable JavaType t2) {
        return t == null ? t2 == null : t == t2 || t.equals(t2);
    }
}

