/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.FallThroughStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class FallThroughVisitor<P>
extends JavaIsoVisitor<P> {
    private static final Pattern RELIEF_PATTERN = Pattern.compile("falls?[ -]?thr(u|ough)");
    private final FallThroughStyle style;

    private static boolean isLastCase(J.Case caze, J.Switch switzh) {
        J.Block switchBlock = switzh.getCases();
        return caze == switchBlock.getStatements().get(switchBlock.getStatements().size() - 1);
    }

    @Override
    public J.Case visitCase(J.Case caze, P p) {
        J c = super.visitCase(caze, (Object)p);
        J.Switch switzh = (J.Switch)this.getCursor().dropParentUntil(J.Switch.class::isInstance).getValue();
        if ((Boolean.TRUE.equals(this.style.getCheckLastCaseGroup()) || !FallThroughVisitor.isLastCase((J.Case)c, switzh)) && FindLastLineBreaksOrFallsThroughComments.find(switzh, (J.Case)c).isEmpty()) {
            this.doAfterVisit(new AddBreak((J.Case)c));
        }
        return c;
    }

    public FallThroughVisitor(FallThroughStyle style) {
        this.style = style;
    }

    public FallThroughStyle getStyle() {
        return this.style;
    }

    @NonNull
    public String toString() {
        return "FallThroughVisitor(style=" + this.getStyle() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FallThroughVisitor)) {
            return false;
        }
        FallThroughVisitor other = (FallThroughVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FallThroughStyle this$style = this.getStyle();
        FallThroughStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FallThroughVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FallThroughStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }

    private static class FindLastLineBreaksOrFallsThroughComments {
        private FindLastLineBreaksOrFallsThroughComments() {
        }

        private static Set<J> find(J.Switch enclosingSwitch, J.Case scope) {
            HashSet<J> references = new HashSet<J>();
            new FindLastLineBreaksOrFallsThroughCommentsVisitor(scope).visit(enclosingSwitch, references);
            return references;
        }

        private static class FindLastLineBreaksOrFallsThroughCommentsVisitor
        extends JavaIsoVisitor<Set<J>> {
            private static final Predicate<Comment> HAS_RELIEF_PATTERN_COMMENT = comment -> comment instanceof TextComment && RELIEF_PATTERN.matcher(((TextComment)comment).getText()).find();
            private final J.Case scope;

            public FindLastLineBreaksOrFallsThroughCommentsVisitor(J.Case scope) {
                this.scope = scope;
            }

            private static boolean lastLineBreaksOrFallsThrough(List<? extends Tree> trees) {
                return trees.stream().reduce((s1, s2) -> s2).map(s -> s instanceof J.Return || s instanceof J.Break || s instanceof J.Continue || s instanceof J.Throw || ((J)s).getComments().stream().anyMatch(HAS_RELIEF_PATTERN_COMMENT)).orElse(false);
            }

            @Override
            public J.Switch visitSwitch(J.Switch switzh, Set<J> ctx) {
                J s = super.visitSwitch(switzh, ctx);
                List<Statement> statements = ((J.Switch)s).getCases().getStatements();
                for (int i = 0; i < statements.size() - 1; ++i) {
                    J.Case caze;
                    if (!(statements.get(i) instanceof J.Case) || (caze = (J.Case)statements.get(i)) != this.scope || !statements.get(i + 1).getPrefix().getComments().stream().anyMatch(HAS_RELIEF_PATTERN_COMMENT)) continue;
                    ctx.add(s);
                }
                return s;
            }

            @Override
            public J.Case visitCase(J.Case caze, Set<J> ctx) {
                J c = super.visitCase(caze, ctx);
                if (c == this.scope && (((J.Case)c).getStatements().isEmpty() || FindLastLineBreaksOrFallsThroughCommentsVisitor.lastLineBreaksOrFallsThrough(((J.Case)c).getStatements()))) {
                    ctx.add(c);
                }
                return c;
            }

            @Override
            public J.Block visitBlock(J.Block block, Set<J> ctx) {
                J b = super.visitBlock(block, ctx);
                if (this.getCursor().isScopeInPath((Tree)this.scope) && (FindLastLineBreaksOrFallsThroughCommentsVisitor.lastLineBreaksOrFallsThrough(((J.Block)b).getStatements()) || ((J.Block)b).getEnd().getComments().stream().anyMatch(HAS_RELIEF_PATTERN_COMMENT))) {
                    ctx.add(b);
                }
                return b;
            }
        }
    }

    private static class AddBreak<P>
    extends JavaIsoVisitor<P> {
        private final J.Case scope;

        public AddBreak(J.Case scope) {
            this.scope = scope;
        }

        @Override
        public J.Case visitCase(J.Case caze, P p) {
            J c = super.visitCase(caze, (Object)p);
            if (this.scope.isScope(c)) {
                if (((J.Case)c).getStatements().stream().noneMatch(J.Break.class::isInstance) && ((J.Case)c).getStatements().stream().reduce((s1, s2) -> s2).map(s -> !(s instanceof J.Block)).orElse(true).booleanValue()) {
                    ArrayList<Statement> statements = new ArrayList<Statement>(((J.Case)c).getStatements());
                    J.Break breakToAdd = this.autoFormat(new J.Break(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null), p, this.getCursor().getParentOrThrow());
                    statements.add(breakToAdd);
                    c = ((J.Case)c).withStatements(ListUtils.map(statements, stmt -> this.autoFormat(stmt, p)));
                }
            }
            return c;
        }

        @Override
        public J.Block visitBlock(J.Block block, P p) {
            J b = super.visitBlock(block, (Object)p);
            if (this.getCursor().isScopeInPath((Tree)this.scope)) {
                if (((J.Block)b).getStatements().stream().noneMatch(J.Break.class::isInstance) && ((J.Block)b).getStatements().stream().reduce((s1, s2) -> s2).map(s -> !(s instanceof J.Block)).orElse(true).booleanValue()) {
                    List<Statement> statements = ((J.Block)b).getStatements();
                    J.Break breakToAdd = this.autoFormat(new J.Break(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null), p, this.getCursor().getParentOrThrow());
                    statements.add(breakToAdd);
                    b = ((J.Block)b).withStatements(ListUtils.map(statements, stmt -> this.autoFormat(stmt, p)));
                }
            }
            return b;
        }
    }
}

