/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.25.0")
public class Guard {
    private final Cursor cursor;
    private final Expression expression;

    public static Optional<Guard> from(Cursor cursor) {
        if (!(cursor.getValue() instanceof Expression)) {
            throw new IllegalArgumentException("Cursor must be on an expression");
        }
        Expression e = (Expression)cursor.getValue();
        if (e instanceof J.ControlParentheses && Guard.getControlParenthesesFromParent(cursor).map(c -> c == e).orElse(false).booleanValue()) {
            return Optional.empty();
        }
        return Guard.getTypeSafe(e).map(type -> {
            if (TypeUtils.isAssignableTo(JavaType.Primitive.Boolean, type)) {
                return new Guard(cursor, e);
            }
            return null;
        });
    }

    private static Optional<J.ControlParentheses<?>> getControlParenthesesFromParent(Cursor cursor) {
        Statement parent = (Statement)cursor.dropParentUntil(v -> v instanceof J.If || v instanceof Loop || v instanceof J.Block).getValue();
        J.ControlParentheses<Expression> parentControlParentheses = parent instanceof J.If ? ((J.If)parent).getIfCondition() : (parent instanceof J.WhileLoop ? ((J.WhileLoop)parent).getCondition() : (parent instanceof J.DoWhileLoop ? ((J.DoWhileLoop)parent).getWhileCondition() : null));
        return Optional.ofNullable(parentControlParentheses);
    }

    @Deprecated
    private static boolean isGuardType(Expression e) {
        return e instanceof J.MethodInvocation || e instanceof J.FieldAccess || e instanceof J.ArrayAccess || e instanceof J.TypeCast || e instanceof J.InstanceOf || e instanceof J.Binary || e instanceof J.Parentheses || e instanceof J.ControlParentheses || e instanceof J.Assignment || e instanceof J.AssignmentOperation || e instanceof J.Ternary || e instanceof J.Unary && ((J.Unary)e).getOperator() == J.Unary.Type.Not;
    }

    private static Optional<JavaType> getTypeSafe(Expression e) {
        JavaType type = e.getType();
        if (type != null && !JavaType.Unknown.getInstance().equals(type)) {
            return Optional.of(type);
        }
        if (e instanceof J.Binary) {
            J.Binary binary = (J.Binary)e;
            switch (binary.getOperator()) {
                case And: 
                case Or: 
                case Equal: 
                case NotEqual: {
                    return Optional.of(JavaType.Primitive.Boolean);
                }
            }
            return Optional.empty();
        }
        if (e instanceof J.InstanceOf) {
            return Optional.of(JavaType.Primitive.Boolean);
        }
        return Optional.empty();
    }

    private Guard(Cursor cursor, Expression expression) {
        this.cursor = cursor;
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

