/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class UriCreatedWithHttpScheme
extends Recipe {
    private static final MethodMatcher URI_CREATE = new MethodMatcher("java.net.URI create(..)");
    private static final MethodMatcher STRING_REPLACE = new MethodMatcher("java.lang.String replace(..)");
    private static final LocalFlowSpec<J.Literal, Expression> INSECURE_URI_CREATE = new LocalFlowSpec<J.Literal, Expression>(){

        @Override
        public boolean isSource(J.Literal source, Cursor cursor) {
            return source.getValue() != null && source.getValue().toString().startsWith("http://");
        }

        @Override
        public boolean isSink(Expression sink, Cursor cursor) {
            J.MethodInvocation maybeMethodInvocation = (J.MethodInvocation)cursor.firstEnclosing(J.MethodInvocation.class);
            if (maybeMethodInvocation != null && URI_CREATE.matches(maybeMethodInvocation)) {
                return maybeMethodInvocation.getArguments().contains(sink);
            }
            return false;
        }

        @Override
        public boolean isAdditionalFlowStep(Expression startE, Cursor startC, Expression endE, Cursor endC) {
            boolean isAdditionalFlow = endE instanceof J.Binary;
            if (isAdditionalFlow) {
                J.Binary endBinary = (J.Binary)endE;
                return startE == endBinary.getLeft();
            }
            return false;
        }

        @Override
        public boolean isBarrierGuard(Expression expr) {
            return STRING_REPLACE.matches(expr);
        }
    };

    public String getDisplayName() {
        return "URIs created with an HTTP scheme";
    }

    public String getDescription() {
        return "This is a sample recipe demonstrating a simple application of local data flow analysis.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(URI_CREATE);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J l = super.visitLiteral(literal, ctx);
                if (this.dataflow().findSinks(INSECURE_URI_CREATE).isPresent()) {
                    return ((J.Literal)l).withValue(((J.Literal)l).getValue().toString().replace("http://", "https://")).withValueSource(((J.Literal)l).getValueSource().replace("http://", "https://"));
                }
                return l;
            }
        };
    }
}

