/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.JavaSourceFile;

public class NormalizeTabsOrSpaces
extends Recipe {
    public String getDisplayName() {
        return "Normalize to tabs or spaces";
    }

    public String getDescription() {
        return "Consistently use either tabs or spaces in indentation.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class);
            if (style == null) {
                style = IntelliJ.tabsAndIndents();
            }
            this.doAfterVisit(new NormalizeTabsOrSpacesVisitor(style));
            return cu;
        }
    }
}

