/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.23.0")
public class RemoveRedundantTypeCast
extends Recipe {
    public String getDisplayName() {
        return "Remove redundant casts";
    }

    public String getDescription() {
        return "Removes unnecessary type casts. Does not currently check casts in lambdas, class constructors, and method invocations.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1905");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext executionContext) {
                Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.VariableDeclarations || is instanceof J.NewClass || is instanceof J.Lambda || is instanceof J.MethodInvocation || is instanceof J.MethodDeclaration || is instanceof J.ClassDeclaration);
                if (!(parent.getValue() instanceof J.VariableDeclarations)) {
                    return typeCast;
                }
                TypeTree typeTree = typeCast.getClazz().getTree();
                JavaType expressionType = typeCast.getExpression().getType();
                JavaType namedVariableType = ((J.VariableDeclarations)parent.getValue()).getVariables().get(0).getType();
                if (!(namedVariableType instanceof JavaType.Array) && TypeUtils.isOfClassType(namedVariableType, "java.lang.Object") || !(typeTree instanceof J.ParameterizedType) && (TypeUtils.isOfType(namedVariableType, expressionType) || TypeUtils.isAssignableTo(namedVariableType, expressionType))) {
                    return typeCast.getExpression();
                }
                return super.visitTypeCast(typeCast, executionContext);
            }
        };
    }
}

