/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.openrewrite.Cursor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.analysis.FlowGraph;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class SinkFlow<Source extends Expression, Sink extends J>
extends FlowGraph {
    @Nullable
    private final Cursor source;
    private final LocalFlowSpec<Source, Sink> spec;

    public SinkFlow(@Nullable Cursor source, LocalFlowSpec<Source, Sink> spec) {
        super(source);
        this.source = source;
        this.spec = spec;
    }

    public Cursor getSourceCursor() {
        return Objects.requireNonNull(this.source);
    }

    public Source getSource() {
        return (Source)((Expression)Objects.requireNonNull(this.source).getValue());
    }

    public List<Sink> getSinks() {
        List<List<Cursor>> flows = this.getFlows();
        ArrayList<J> sinks = new ArrayList<J>(flows.size());
        for (List<Cursor> flow : flows) {
            sinks.add((J)flow.get(flow.size() - 1).getValue());
        }
        return sinks;
    }

    public List<List<Cursor>> getFlows() {
        ArrayList<List<Cursor>> flows = new ArrayList<List<Cursor>>();
        Stack<Cursor> path = new Stack<Cursor>();
        path.push(this.getCursor());
        this.recurseGetFlows(this, path, flows);
        return flows;
    }

    public boolean isEmpty() {
        return this.getSinks().isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    private void recurseGetFlows(FlowGraph flowGraph, Stack<Cursor> pathToHere, List<List<Cursor>> pathsToSinks) {
        Cursor cursor = flowGraph.getCursor();
        if (cursor.getValue() instanceof Expression && this.spec.isBarrierGuard((Expression)cursor.getValue())) {
            return;
        }
        boolean isSinkType = this.spec.getSinkType().isAssignableFrom(cursor.getValue().getClass());
        if (isSinkType && this.spec.isSink((J)cursor.getValue(), cursor)) {
            ArrayList<Cursor> flow = new ArrayList<Cursor>(pathToHere);
            flow.add(cursor);
            pathsToSinks.add(flow);
        }
        for (FlowGraph edge : flowGraph.getEdges()) {
            Stack<Cursor> pathToEdge = new Stack<Cursor>();
            pathToEdge.addAll(pathToHere);
            pathToEdge.add(edge.getCursor());
            this.recurseGetFlows(edge, pathToEdge, pathsToSinks);
        }
    }

    LocalFlowSpec<Source, Sink> getSpec() {
        return this.spec;
    }
}

