/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.analysis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.openrewrite.Cursor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.analysis.FlowGraph;
import org.openrewrite.java.dataflow.analysis.SinkFlow;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class ForwardFlow
extends JavaVisitor<Integer> {
    private static final MethodMatcher methodMatcherToString = new MethodMatcher("java.lang.String toString()");

    public static void findSinks(SinkFlow<?, ?> root) {
        Iterator cursorPath = root.getCursor().getPathAsCursors();
        VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(cursorPath, root, root.getSpec());
        if (variableNameToFlowGraph.nextVariableName != null) {
            Object next;
            Object taintStmt = null;
            Cursor taintStmtCursorParent = null;
            while (cursorPath.hasNext() && !((next = (taintStmtCursorParent = (Cursor)cursorPath.next()).getValue()) instanceof J.Block)) {
                if (!(next instanceof J)) continue;
                taintStmt = next;
            }
            HashMap<String, FlowGraph> initialFlow = new HashMap<String, FlowGraph>();
            initialFlow.put(variableNameToFlowGraph.nextVariableName, variableNameToFlowGraph.nextFlowGraph);
            Analysis analysis = new Analysis(root.getSpec(), initialFlow);
            if (taintStmt instanceof J.WhileLoop || taintStmt instanceof J.DoWhileLoop || taintStmt instanceof J.ForLoop) {
                Statement body = taintStmt instanceof J.WhileLoop ? ((J.WhileLoop)taintStmt).getBody() : (taintStmt instanceof J.DoWhileLoop ? ((J.DoWhileLoop)taintStmt).getBody() : ((J.ForLoop)taintStmt).getBody());
                analysis.visit(body, 0, taintStmtCursorParent);
            } else {
                boolean seenRoot = false;
                Cursor blockCursor = root.getCursor().dropParentUntil(J.Block.class::isInstance);
                for (Statement statement : ((J.Block)blockCursor.getValue()).getStatements()) {
                    if (seenRoot) {
                        analysis.visit(statement, 0, blockCursor);
                    }
                    if (statement != taintStmt) continue;
                    seenRoot = true;
                }
            }
        }
    }

    private static VariableNameToFlowGraph computeVariableAssignment(Iterator<Cursor> cursorPath, FlowGraph currentFlow, LocalFlowSpec<?, ?> spec) {
        if (cursorPath.hasNext()) {
            cursorPath.next();
        }
        String nextVariableName = null;
        FlowGraph nextFlowGraph = currentFlow;
        while (cursorPath.hasNext()) {
            Cursor previousCursor;
            Cursor ancestorCursor = cursorPath.next();
            Object ancestor = ancestorCursor.getValue();
            if (ancestor instanceof Expression && spec.isAdditionalFlowStep((Expression)(previousCursor = nextFlowGraph.getCursor()).getValue(), previousCursor, (Expression)ancestor, ancestorCursor)) {
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.Binary) break;
            if (ancestor instanceof J.MethodInvocation) {
                if (!methodMatcherToString.matches((J.MethodInvocation)ancestor)) break;
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.Ternary) {
                J.Ternary ternary = (J.Ternary)ancestor;
                Object previousCursorValue = nextFlowGraph.getCursor().getValue();
                if (ternary.getTruePart() != previousCursorValue && ternary.getFalsePart() != previousCursorValue) break;
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.TypeCast || ancestor instanceof J.Parentheses || ancestor instanceof J.ControlParentheses) {
                nextFlowGraph = nextFlowGraph.addEdge(ancestorCursor);
                continue;
            }
            if (ancestor instanceof J.NewClass) break;
            if (!(ancestor instanceof J.Assignment) && !(ancestor instanceof J.AssignmentOperation) && !(ancestor instanceof J.VariableDeclarations.NamedVariable)) continue;
            Expression variable = ancestor instanceof J.Assignment ? ((J.Assignment)ancestor).getVariable() : (ancestor instanceof J.AssignmentOperation ? ((J.AssignmentOperation)ancestor).getVariable() : ((J.VariableDeclarations.NamedVariable)ancestor).getName());
            if (!((variable = ForwardFlow.unwrap(variable)) instanceof J.Identifier)) continue;
            nextVariableName = ((J.Identifier)variable).getSimpleName();
            break;
        }
        return new VariableNameToFlowGraph(nextVariableName, nextFlowGraph);
    }

    private static Expression unwrap(Expression expression) {
        if (expression instanceof J.Parentheses) {
            return ForwardFlow.unwrap((Expression)((J.Parentheses)expression).getTree());
        }
        return expression;
    }

    private static final class VariableNameToFlowGraph {
        @Nullable
        String nextVariableName;
        FlowGraph nextFlowGraph;

        public VariableNameToFlowGraph(@Nullable String nextVariableName, FlowGraph nextFlowGraph) {
            this.nextVariableName = nextVariableName;
            this.nextFlowGraph = nextFlowGraph;
        }
    }

    private static class Analysis
    extends JavaVisitor<Integer> {
        final LocalFlowSpec<?, ?> localFlowSpec;
        Stack<Map<String, FlowGraph>> flowsByIdentifier = new Stack();

        Analysis(LocalFlowSpec<?, ?> localFlowSpec, Map<String, FlowGraph> initial) {
            this.localFlowSpec = localFlowSpec;
            this.flowsByIdentifier.push(initial);
        }

        @Override
        public J visitVariable(J.VariableDeclarations.NamedVariable variable, Integer p) {
            this.flowsByIdentifier.peek().remove(variable.getSimpleName());
            return super.visitVariable(variable, p);
        }

        @Override
        public J visitLambda(J.Lambda lambda, Integer p) {
            for (J parameter : lambda.getParameters().getParameters()) {
                new JavaIsoVisitor<Integer>(){

                    @Override
                    public J.Identifier visitIdentifier(J.Identifier identifier, Integer integer) {
                        flowsByIdentifier.peek().remove(identifier.getSimpleName());
                        return identifier;
                    }
                }.visit(parameter, 0);
            }
            return super.visitLambda(lambda, p);
        }

        @Override
        public J visitIdentifier(J.Identifier ident, Integer p) {
            J.Assignment parentAssignment = (J.Assignment)this.getCursor().firstEnclosing(J.Assignment.class);
            if (parentAssignment != null && ForwardFlow.unwrap(parentAssignment.getVariable()) == ident) {
                return ident;
            }
            J.FieldAccess parentFieldAccess = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
            if (parentFieldAccess != null && parentFieldAccess.getName() == ident) {
                return ident;
            }
            J.NewClass parentNewClass = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
            if (parentNewClass != null && parentNewClass.getClazz() == ident) {
                return ident;
            }
            J.MethodInvocation parentMethodInvocation = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
            if (parentMethodInvocation != null && parentMethodInvocation.getName() == ident) {
                return ident;
            }
            FlowGraph flowGraph = this.flowsByIdentifier.peek().get(ident.getSimpleName());
            if (flowGraph != null) {
                FlowGraph next = flowGraph.addEdge(this.getCursor());
                this.flowsByIdentifier.peek().put(ident.getSimpleName(), next);
                VariableNameToFlowGraph variableNameToFlowGraph = ForwardFlow.computeVariableAssignment(this.getCursor().getPathAsCursors(), next, this.localFlowSpec);
                if (variableNameToFlowGraph.nextVariableName != null) {
                    this.flowsByIdentifier.peek().put(variableNameToFlowGraph.nextVariableName, variableNameToFlowGraph.nextFlowGraph);
                }
            }
            return ident;
        }

        @Override
        public J visitBlock(J.Block block, Integer p) {
            this.flowsByIdentifier.push(new HashMap<String, FlowGraph>(this.flowsByIdentifier.peek()));
            J b = super.visitBlock(block, p);
            this.flowsByIdentifier.pop();
            return b;
        }

        @Override
        public J visitAssignment(J.Assignment assignment, Integer integer) {
            J.Assignment a = (J.Assignment)super.visitAssignment(assignment, integer);
            String variableName = ((J.Identifier)ForwardFlow.unwrap(a.getVariable())).getSimpleName();
            if (a.getAssignment() != this.flowsByIdentifier.peek().get(variableName).getCursor().getValue()) {
                this.flowsByIdentifier.peek().remove(variableName);
            }
            return a;
        }

        @Override
        public J visitNewClass(J.NewClass newClass, Integer integer) {
            return super.visitNewClass(newClass, integer);
        }
    }
}

