/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public final class RemoveUnusedLocalVariables
extends Recipe {
    @Option(displayName="Ignore matching variable names", description="An array of variable identifier names for local variables to ignore, even if the local variable is unused.", required=false, example="[unused, notUsed, IGNORE_ME]")
    @Nullable
    @Incubating(since="7.17.2")
    private final String[] ignoreVariablesNamed;

    public String getDisplayName() {
        return "Remove unused local variables";
    }

    public String getDescription() {
        return "If a local variable is declared but not used, it is dead code and should be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1481");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveUnusedLocalVariablesVisitor(this.ignoreVariablesNamed);
    }

    public RemoveUnusedLocalVariables(@Nullable String[] ignoreVariablesNamed) {
        this.ignoreVariablesNamed = ignoreVariablesNamed;
    }

    @Nullable
    public String[] getIgnoreVariablesNamed() {
        return this.ignoreVariablesNamed;
    }

    @NonNull
    public String toString() {
        return "RemoveUnusedLocalVariables(ignoreVariablesNamed=" + Arrays.deepToString(this.getIgnoreVariablesNamed()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnusedLocalVariables)) {
            return false;
        }
        RemoveUnusedLocalVariables other = (RemoveUnusedLocalVariables)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getIgnoreVariablesNamed(), other.getIgnoreVariablesNamed());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveUnusedLocalVariables;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getIgnoreVariablesNamed());
        return result;
    }

    private static class References {
        private static final J.Unary.Type[] incrementKinds = new J.Unary.Type[]{J.Unary.Type.PreIncrement, J.Unary.Type.PreDecrement, J.Unary.Type.PostIncrement, J.Unary.Type.PostDecrement};
        private static final Predicate<Cursor> isUnaryIncrementKind = t -> t.getValue() instanceof J.Unary && References.isIncrementKind(t);

        private References() {
        }

        private static boolean isIncrementKind(Cursor tree) {
            if (tree.getValue() instanceof J.Unary) {
                J.Unary unary = (J.Unary)tree.getValue();
                return Arrays.stream(incrementKinds).anyMatch(kind -> kind == unary.getOperator());
            }
            return false;
        }

        @Nullable
        private static Cursor dropParentWhile(Predicate<Object> valuePredicate, Cursor cursor) {
            while (cursor != null && valuePredicate.test(cursor.getValue())) {
                cursor = cursor.getParent();
            }
            return cursor;
        }

        @Nullable
        private static Cursor dropParentUntil(Predicate<Object> valuePredicate, Cursor cursor) {
            while (cursor != null && !valuePredicate.test(cursor.getValue())) {
                cursor = cursor.getParent();
            }
            return cursor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isRhsValue(Cursor tree) {
            J.AssignmentOperation assignmentOperation;
            if (!(tree.getValue() instanceof J.Identifier)) {
                return false;
            }
            Cursor parent = References.dropParentWhile(J.Parentheses.class::isInstance, tree.getParent());
            assert (parent != null);
            if (parent.getValue() instanceof J.Assignment) {
                if (References.dropParentUntil(J.ControlParentheses.class::isInstance, parent) != null) {
                    return true;
                }
                J.Assignment assignment = (J.Assignment)parent.getValue();
                if (assignment.getVariable() == tree.getValue()) return false;
                return true;
            }
            if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable) {
                J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)parent.getValue();
                if (namedVariable.getName() == tree.getValue()) return false;
                return true;
            }
            if (parent.getValue() instanceof J.AssignmentOperation && (assignmentOperation = (J.AssignmentOperation)parent.getValue()).getVariable() == tree.getValue()) {
                J grandParent = (J)parent.dropParentUntil(J.class::isInstance).getValue();
                if (grandParent instanceof Expression) return true;
                if (!(grandParent instanceof J.Return)) return false;
                return true;
            }
            if (!isUnaryIncrementKind.test(parent)) return true;
            if (parent.dropParentUntil(J.class::isInstance).getValue() instanceof J.Block) return false;
            return true;
        }

        private static List<J> findRhsReferences(J j, final J.Identifier target) {
            ArrayList<J> refs = new ArrayList<J>();
            new JavaIsoVisitor<List<J>>(){

                @Override
                public J.Identifier visitIdentifier(J.Identifier identifier, List<J> ctx) {
                    if (identifier.getSimpleName().equals(target.getSimpleName()) && References.isRhsValue(this.getCursor())) {
                        ctx.add(identifier);
                    }
                    return super.visitIdentifier(identifier, ctx);
                }
            }.visit(j, refs);
            return refs;
        }

        private static List<Statement> findLhsReferences(J j, final J.Identifier target) {
            JavaIsoVisitor<List<Statement>> visitor = new JavaIsoVisitor<List<Statement>>(){

                @Override
                public J.Assignment visitAssignment(J.Assignment assignment, List<Statement> ctx) {
                    J.Identifier i;
                    if (assignment.getVariable() instanceof J.Identifier && (i = (J.Identifier)assignment.getVariable()).getSimpleName().equals(target.getSimpleName())) {
                        ctx.add(assignment);
                    }
                    return super.visitAssignment(assignment, ctx);
                }

                @Override
                public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, List<Statement> ctx) {
                    J.Identifier i;
                    if (assignOp.getVariable() instanceof J.Identifier && (i = (J.Identifier)assignOp.getVariable()).getSimpleName().equals(target.getSimpleName())) {
                        ctx.add(assignOp);
                    }
                    return super.visitAssignmentOperation(assignOp, ctx);
                }

                @Override
                public J.Unary visitUnary(J.Unary unary, List<Statement> ctx) {
                    J.Identifier i;
                    if (unary.getExpression() instanceof J.Identifier && (i = (J.Identifier)unary.getExpression()).getSimpleName().equals(target.getSimpleName())) {
                        ctx.add(unary);
                    }
                    return super.visitUnary(unary, ctx);
                }
            };
            ArrayList<Statement> refs = new ArrayList<Statement>();
            visitor.visit(j, refs);
            return refs;
        }
    }

    private static class RemoveUnusedLocalVariablesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Set<String> ignoreVariableNames;

        RemoveUnusedLocalVariablesVisitor(String[] ignoreVariablesNamed) {
            if (ignoreVariablesNamed != null) {
                this.ignoreVariableNames = new HashSet<String>(ignoreVariablesNamed.length);
                this.ignoreVariableNames.addAll(Arrays.asList(ignoreVariablesNamed));
            }
        }

        private Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.ForEachLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Resource || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda);
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            if (this.ignoreVariableNames != null && this.ignoreVariableNames.contains(variable.getSimpleName())) {
                return variable;
            }
            Cursor parentScope = this.getCursorToParentScope(this.getCursor());
            J parent = (J)parentScope.getValue();
            if (parentScope.getParent() == null || parentScope.getParent().getValue() instanceof J.ClassDeclaration || parentScope.getParent().getValue() instanceof J.NewClass || parent instanceof J.MethodDeclaration || parent instanceof J.ForLoop.Control || parent instanceof J.ForEachLoop.Control || parent instanceof J.Try.Resource || parent instanceof J.Try.Catch || parent instanceof J.MultiCatch || parent instanceof J.Lambda || this.initializerMightSideEffect(variable)) {
                return variable;
            }
            List readReferences = References.findRhsReferences((J)parentScope.getValue(), variable.getName());
            if (readReferences.isEmpty()) {
                List assignmentReferences = References.findLhsReferences((J)parentScope.getValue(), variable.getName());
                for (Statement ref : assignmentReferences) {
                    this.doAfterVisit(new DeleteStatement(ref));
                }
                return null;
            }
            return super.visitVariable(variable, ctx);
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            if (!multiVariable.getAllAnnotations().isEmpty()) {
                return multiVariable;
            }
            J mv = super.visitVariableDeclarations(multiVariable, ctx);
            if (((J.VariableDeclarations)mv).getVariables().isEmpty()) {
                this.doAfterVisit(new DeleteStatement((Statement)mv));
            }
            return mv;
        }

        private boolean initializerMightSideEffect(J.VariableDeclarations.NamedVariable variable) {
            if (variable.getInitializer() == null) {
                return false;
            }
            AtomicBoolean mightSideEffect = new AtomicBoolean(false);
            new JavaIsoVisitor<AtomicBoolean>(){

                @Override
                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, AtomicBoolean result) {
                    result.set(true);
                    return methodInvocation;
                }

                @Override
                public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean result) {
                    result.set(true);
                    return assignment;
                }
            }.visit(variable.getInitializer(), mightSideEffect);
            return mightSideEffect.get();
        }
    }
}

