/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.dataflow.LastRead;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

@Incubating(since="7.20.0")
public class UpdateLastRead
extends Recipe {
    public String getDisplayName() {
        return "Last read data flow analysis";
    }

    public String getDescription() {
        return "Update last read edges tracking uses of local variables and fields.";
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                ((HashMap)this.getCursor().dropParentUntil(J.Block.class::isInstance).computeMessageIfAbsent("variables", v -> new HashMap())).put(variable.getSimpleName(), variable.getId());
                return super.visitVariable(variable, ctx);
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                UUID id;
                J i = super.visitIdentifier(identifier, ctx);
                i = ((J.Identifier)i).withMarkers(((J.Identifier)i).getMarkers().removeByType(LastRead.class));
                Map variableIds = (Map)this.getCursor().getNearestMessage("variables");
                if (variableIds != null && (id = (UUID)variableIds.get(identifier.getSimpleName())) != null) {
                    Cursor parent = this.getCursor().dropParentUntil(t -> t instanceof J && !(t instanceof J.Parentheses));
                    if (this.cursorIsInstanceOf(parent, J.Unary.class, J.Binary.class, J.If.class, J.Synchronized.class, J.ControlParentheses.class, J.ForLoop.Control.class, J.ForEachLoop.Control.class, J.WhileLoop.class, J.DoWhileLoop.class, J.InstanceOf.class, J.AssignmentOperation.class)) {
                        i = ((J.Identifier)i).withMarkers(((J.Identifier)i).getMarkers().setByType((Marker)new LastRead(Tree.randomId(), id)));
                    } else {
                        Cursor grandparent = parent.dropParentUntil(t -> t instanceof J && !(t instanceof J.Parentheses));
                        if (this.cursorIsInstanceOf(grandparent, J.Binary.class)) {
                            i = ((J.Identifier)i).withMarkers(((J.Identifier)i).getMarkers().setByType((Marker)new LastRead(Tree.randomId(), id)));
                        }
                    }
                }
                return i;
            }

            @SafeVarargs
            private final boolean cursorIsInstanceOf(Cursor cursor, Class<? extends J> ... types) {
                for (Class<? extends J> type : types) {
                    if (!type.isInstance(cursor.getValue())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

