/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class GenerateGetterAndSetterVisitor<P>
extends JavaIsoVisitor<P> {
    private final String fieldName;
    private final String capitalizedFieldName;
    private final JavaTemplate getter = JavaTemplate.builder(() -> ((GenerateGetterAndSetterVisitor)this).getCursor(), "public #{} #{}() {return #{};}").build();
    private final JavaTemplate setter = JavaTemplate.builder(() -> ((GenerateGetterAndSetterVisitor)this).getCursor(), "public void set#{}(#{} #{}) {this.#{} = #{};}").build();

    public GenerateGetterAndSetterVisitor(String fieldName) {
        this.fieldName = fieldName;
        this.capitalizedFieldName = StringUtils.capitalize((String)fieldName);
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        if (variable.isField(this.getCursor()) && variable.getSimpleName().equals(this.fieldName)) {
            this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "varCursor", (Object)this.getCursor());
        }
        return super.visitVariable(variable, (Object)p);
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J mi;
        block5: {
            block4: {
                mi = super.visitMethodDeclaration(method, (Object)p);
                if (((J.MethodDeclaration)mi).getSimpleName().equals("get" + this.capitalizedFieldName)) break block4;
                if (!((J.MethodDeclaration)mi).getSimpleName().equals("is" + this.capitalizedFieldName)) break block5;
            }
            this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("getter-exists", (Object)true);
        }
        if (((J.MethodDeclaration)mi).getSimpleName().equals("set" + this.capitalizedFieldName)) {
            this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("setter-exists", (Object)true);
        }
        return mi;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        Cursor varCursor = (Cursor)this.getCursor().pollMessage("varCursor");
        if (varCursor != null) {
            J.VariableDeclarations.NamedVariable var = (J.VariableDeclarations.NamedVariable)varCursor.getValue();
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified(var.getType());
            JavaType.Primitive primitive = TypeUtils.asPrimitive(var.getType());
            String getterPrefix = "get";
            String fieldType = null;
            if (primitive != null) {
                getterPrefix = primitive == JavaType.Primitive.Boolean ? "is" : "get";
                fieldType = primitive.getKeyword();
            } else if (fullyQualified != null) {
                fieldType = fullyQualified.getClassName();
            }
            if (this.getCursor().pollMessage("getter-exists") == null) {
                Statement getterStatement = this.maybeAutoFormat(c, (J.ClassDeclaration)((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withStatements(Collections.emptyList())).withTemplate(this.getter, ((J.ClassDeclaration)c).getBody().getCoordinates().lastStatement(), fieldType, getterPrefix + this.capitalizedFieldName, var.getSimpleName()), p).getBody().getStatements().get(0);
                c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withStatements(ListUtils.concat(((J.ClassDeclaration)c).getBody().getStatements(), (Object)getterStatement)));
            }
            if (this.getCursor().pollMessage("setter-exists") == null) {
                Statement setterStatement = this.maybeAutoFormat(c, (J.ClassDeclaration)((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withStatements(Collections.emptyList())).withTemplate(this.setter, ((J.ClassDeclaration)c).getBody().getCoordinates().lastStatement(), this.capitalizedFieldName, fieldType, var.getSimpleName(), var.getSimpleName(), var.getSimpleName()), p).getBody().getStatements().get(0);
                c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withStatements(ListUtils.concat(((J.ClassDeclaration)c).getBody().getStatements(), (Object)setterStatement)));
            }
        }
        return c;
    }
}

