/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeSignatureBuilder;

public class JavaReflectionTypeSignatureBuilder
implements JavaTypeSignatureBuilder {
    private Set<String> typeVariableNameStack;

    @Override
    public String signature(@Nullable Object t) {
        if (t == null) {
            return "{undefined}";
        }
        if (t instanceof Class) {
            Class clazz = (Class)t;
            if (clazz.isArray()) {
                return this.arraySignature(clazz);
            }
            if (clazz.isPrimitive()) {
                return this.primitiveSignature(clazz);
            }
            StringBuilder s = new StringBuilder(this.classSignature(clazz));
            if (clazz.getTypeParameters().length > 0) {
                StringJoiner typeParams = new StringJoiner(", ", "<", ">");
                for (TypeVariable typeParameter : clazz.getTypeParameters()) {
                    typeParams.add(this.signature(typeParameter));
                }
                s.append(typeParams);
            }
            return s.toString();
        }
        if (t instanceof ParameterizedType) {
            return this.parameterizedSignature(t);
        }
        if (t instanceof WildcardType) {
            return this.genericSignature(t);
        }
        if (t instanceof TypeVariable) {
            return this.genericSignature(t);
        }
        if (t instanceof GenericArrayType) {
            return this.arraySignature(t);
        }
        throw new UnsupportedOperationException("Unknown type " + t.getClass().getName());
    }

    @Override
    public String arraySignature(Object type) {
        if (type instanceof GenericArrayType) {
            return this.signature(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof Class) {
            Class array = (Class)type;
            return this.signature(array.getComponentType()) + "[]";
        }
        throw new UnsupportedOperationException("Unknown array type " + type.getClass().getName());
    }

    @Override
    public String classSignature(Object type) {
        Class clazz = (Class)type;
        return clazz.getName();
    }

    @Override
    public String genericSignature(Object type) {
        if (type instanceof TypeVariable) {
            String boundsStr;
            TypeVariable typeVar = (TypeVariable)type;
            String name = typeVar.getName();
            if (this.typeVariableNameStack == null) {
                this.typeVariableNameStack = new HashSet<String>();
            }
            StringBuilder s = new StringBuilder("Generic{" + name);
            if (this.typeVariableNameStack.add(name) && typeVar.getBounds().length > 0 && !(boundsStr = this.genericBounds(typeVar.getBounds())).isEmpty()) {
                s.append(" extends ").append(boundsStr);
            }
            s.append('}');
            this.typeVariableNameStack.remove(name);
            return s.toString();
        }
        if (type instanceof WildcardType) {
            String boundsStr;
            WildcardType wildcard = (WildcardType)type;
            StringBuilder s = new StringBuilder("Generic{?");
            if (wildcard.getLowerBounds().length > 0) {
                String boundsStr2 = this.genericBounds(wildcard.getLowerBounds());
                if (!boundsStr2.isEmpty()) {
                    s.append(" super ").append(boundsStr2);
                }
            } else if (wildcard.getUpperBounds().length > 0 && !(boundsStr = this.genericBounds(wildcard.getUpperBounds())).isEmpty()) {
                s.append(" extends ").append(boundsStr);
            }
            s.append('}');
            return s.toString();
        }
        throw new UnsupportedOperationException("Unexpected generic type " + type.getClass().getName());
    }

    private String genericBounds(Type[] bounds) {
        StringJoiner boundJoiner = new StringJoiner(" & ");
        for (Type bound : bounds) {
            String boundStr = this.signature(bound);
            if (boundStr.equals("java.lang.Object")) continue;
            boundJoiner.add(boundStr);
        }
        return boundJoiner.toString();
    }

    @Override
    public String parameterizedSignature(Object type) {
        ParameterizedType pt = (ParameterizedType)type;
        String className = ((Class)pt.getRawType()).getName();
        StringBuilder s = new StringBuilder(className);
        StringJoiner typeParameters = new StringJoiner(", ", "<", ">");
        for (Type typeArgument : pt.getActualTypeArguments()) {
            typeParameters.add(this.signature(typeArgument));
        }
        s.append(typeParameters);
        return s.toString();
    }

    @Override
    public String primitiveSignature(Object type) {
        return ((Class)type).getName();
    }

    public String methodSignature(Constructor<?> ctor, String declaringTypeName) {
        StringBuilder s = new StringBuilder(declaringTypeName);
        s.append("{name=").append("<constructor>");
        s.append(",return=").append(declaringTypeName);
        StringJoiner parameterTypeSignatures = new StringJoiner(",", "[", "]");
        if (ctor.getParameters().length > 0) {
            for (Parameter parameter : ctor.getParameters()) {
                Class<?> parameterizedType = parameter.getParameterizedType();
                parameterTypeSignatures.add(this.signature(parameterizedType == null ? parameter.getType() : parameterizedType));
            }
        }
        s.append(",parameters=").append(parameterTypeSignatures);
        s.append('}');
        return s.toString();
    }

    public String methodSignature(Method method, String declaringTypeName) {
        StringBuilder s = new StringBuilder(declaringTypeName);
        s.append("{name=").append(method.getName());
        s.append(",return=").append(this.signature(method.getGenericReturnType()));
        StringJoiner parameterTypeSignatures = new StringJoiner(",", "[", "]");
        if (method.getParameters().length > 0) {
            for (Parameter parameter : method.getParameters()) {
                Class<?> parameterizedType = parameter.getParameterizedType();
                parameterTypeSignatures.add(this.signature(parameterizedType == null ? parameter.getType() : parameterizedType));
            }
        }
        s.append(",parameters=").append(parameterTypeSignatures);
        s.append('}');
        return s.toString();
    }

    public String variableSignature(Field field) {
        return field.getDeclaringClass().getName() + "{name=" + field.getName() + '}';
    }
}

