/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import io.github.classgraph.ArrayTypeSignature;
import io.github.classgraph.BaseTypeSignature;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.ReferenceTypeSignature;
import io.github.classgraph.TypeArgument;
import io.github.classgraph.TypeParameter;
import io.github.classgraph.TypeVariableSignature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeSignatureBuilder;
import org.openrewrite.java.tree.JavaType;

public class ClassgraphJavaTypeSignatureBuilder
implements JavaTypeSignatureBuilder {
    private Set<String> typeVariableNameStack;
    private final Map<String, JavaType.FullyQualified> jvmTypes;

    @Override
    public String signature(@Nullable Object type) {
        if (type == null) {
            return "{undefined}";
        }
        HierarchicalTypeSignature typeSignature = (HierarchicalTypeSignature)type;
        if (typeSignature instanceof ClassRefTypeSignature) {
            ClassRefTypeSignature classRef = (ClassRefTypeSignature)typeSignature;
            if (!classRef.getTypeArguments().isEmpty()) {
                return this.parameterizedSignature(typeSignature);
            }
            return this.classSignature(typeSignature);
        }
        if (typeSignature instanceof ClassTypeSignature) {
            return this.parameterizedSignature(typeSignature);
        }
        if (typeSignature instanceof ArrayTypeSignature) {
            return this.arraySignature(typeSignature);
        }
        if (typeSignature instanceof TypeVariableSignature || typeSignature instanceof TypeParameter || typeSignature instanceof TypeArgument) {
            return this.genericSignature(typeSignature);
        }
        if (typeSignature instanceof BaseTypeSignature) {
            return this.primitiveSignature(typeSignature);
        }
        throw new UnsupportedOperationException("Unexpected signature type " + type.getClass().getName());
    }

    @Override
    public String arraySignature(Object type) {
        ArrayTypeSignature arrSignature = (ArrayTypeSignature)type;
        return this.signature(arrSignature.getNestedType()) + "[]";
    }

    @Override
    public String classSignature(Object type) {
        String className;
        ClassInfo classInfo;
        if (type instanceof ClassTypeSignature) {
            try {
                Method getClassInfo = ClassTypeSignature.class.getDeclaredMethod("getClassInfo", new Class[0]);
                getClassInfo.setAccessible(true);
                classInfo = (ClassInfo)getClassInfo.invoke(type, new Object[0]);
                Method getClassName = ClassTypeSignature.class.getDeclaredMethod("getClassName", new Class[0]);
                getClassName.setAccessible(true);
                className = (String)getClassName.invoke(type, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else if (type instanceof ClassRefTypeSignature) {
            ClassRefTypeSignature clazz = (ClassRefTypeSignature)type;
            classInfo = clazz.getClassInfo();
            className = clazz.getFullyQualifiedClassName();
        } else {
            throw new UnsupportedOperationException("Unknown class type " + type.getClass().getName());
        }
        if (classInfo == null) {
            JavaType.FullyQualified fallback = this.jvmTypes.get(className);
            if (fallback != null) {
                return fallback.getFullyQualifiedName();
            }
            if (className.equals("java.lang.Object")) {
                return className;
            }
            return "{undefined}";
        }
        return className;
    }

    @Override
    public String genericSignature(Object type) {
        if (type instanceof TypeVariableSignature) {
            TypeVariableSignature typeVariableSignature = (TypeVariableSignature)type;
            try {
                return this.signature(typeVariableSignature.resolve());
            }
            catch (IllegalArgumentException ignored) {
                return "Generic{" + typeVariableSignature.getName() + "}";
            }
        }
        if (type instanceof TypeArgument) {
            return this.generic((TypeArgument)type);
        }
        if (type instanceof TypeParameter) {
            return this.generic((TypeParameter)type);
        }
        throw new UnsupportedOperationException("Unexpected generic type " + type.getClass().getName());
    }

    private String generic(TypeArgument typeArgument) {
        StringBuilder s = new StringBuilder();
        switch (typeArgument.getWildcard()) {
            case NONE: {
                s.append(this.signature(typeArgument.getTypeSignature()));
                break;
            }
            case EXTENDS: {
                String bound = this.signature(typeArgument.getTypeSignature());
                if (bound.equals("java.lang.Object")) {
                    s.append("Generic{?}");
                    break;
                }
                s.append("Generic{? extends ").append(bound).append('}');
                break;
            }
            case SUPER: {
                String bound = this.signature(typeArgument.getTypeSignature());
                if (bound.equals("java.lang.Object")) {
                    s.append("Generic{?}");
                    break;
                }
                s.append("Generic{? super ").append(bound).append('}');
                break;
            }
            case ANY: {
                s.append("Generic{?}");
            }
        }
        return s.toString();
    }

    public String generic(TypeParameter typeParameter) {
        String name = typeParameter.getName();
        if (this.typeVariableNameStack == null) {
            this.typeVariableNameStack = new HashSet<String>();
        }
        if (this.typeVariableNameStack.add(name)) {
            StringBuilder bounds = new StringBuilder();
            if (typeParameter.getClassBound() != null) {
                String bound = this.signature(typeParameter.getClassBound());
                if (!bound.equals("java.lang.Object")) {
                    bounds.append(bound);
                }
            } else if (typeParameter.getInterfaceBounds() != null) {
                StringJoiner interfaceBounds = new StringJoiner(" & ");
                for (ReferenceTypeSignature interfaceBound : typeParameter.getInterfaceBounds()) {
                    interfaceBounds.add(this.signature(interfaceBound));
                }
                bounds.append(interfaceBounds);
            }
            this.typeVariableNameStack.remove(name);
            String boundsStr = bounds.toString();
            if (boundsStr.isEmpty()) {
                return "Generic{" + typeParameter.getName() + "}";
            }
            return "Generic{" + typeParameter.getName() + " extends " + boundsStr + "}";
        }
        return "Generic{" + name + "}";
    }

    @Override
    public String parameterizedSignature(Object type) {
        String baseClass = this.classSignature(type);
        if (baseClass.equals("{undefined}")) {
            return baseClass;
        }
        StringBuilder s = new StringBuilder(baseClass);
        StringJoiner typeParameters = new StringJoiner(", ", "<", ">");
        if (type instanceof ClassTypeSignature) {
            ClassTypeSignature clazz = (ClassTypeSignature)type;
            if (!clazz.getTypeParameters().isEmpty()) {
                for (TypeParameter typeParameter : clazz.getTypeParameters()) {
                    typeParameters.add(this.signature(typeParameter));
                }
            }
        } else if (type instanceof ClassRefTypeSignature) {
            ClassRefTypeSignature clazz = (ClassRefTypeSignature)type;
            if (!clazz.getTypeArguments().isEmpty()) {
                for (TypeArgument typeArgument : clazz.getTypeArguments()) {
                    typeParameters.add(this.signature(typeArgument));
                }
            }
        } else {
            throw new UnsupportedOperationException("Unexpected parameterized type " + type.getClass().getName());
        }
        s.append(typeParameters);
        return s.toString();
    }

    @Override
    public String primitiveSignature(Object type) {
        BaseTypeSignature baseTypeSignature = (BaseTypeSignature)type;
        return baseTypeSignature.getTypeStr();
    }

    public String methodSignature(MethodInfo methodInfo) {
        StringBuilder s = new StringBuilder(methodInfo.getClassName());
        s.append("{name=").append(methodInfo.isConstructor() ? "<constructor>" : methodInfo.getName());
        s.append(",return=");
        if (methodInfo.isConstructor()) {
            s.append(methodInfo.getClassName());
        } else {
            s.append(methodInfo.getTypeSignature() == null ? this.signature(methodInfo.getTypeDescriptor().getResultType()) : this.signature(methodInfo.getTypeSignature().getResultType()));
        }
        StringJoiner parameterTypes = new StringJoiner(",", "[", "]");
        for (MethodParameterInfo methodParameterInfo : methodInfo.getParameterInfo()) {
            parameterTypes.add(methodParameterInfo.getTypeSignature() == null ? this.signature(methodParameterInfo.getTypeDescriptor()) : this.signature(methodParameterInfo.getTypeSignature()));
        }
        s.append(",parameters=").append(parameterTypes);
        s.append('}');
        return s.toString();
    }

    public String variableSignature(FieldInfo fieldInfo) {
        return fieldInfo.getClassName() + "{name=" + fieldInfo.getName() + '}';
    }

    public ClassgraphJavaTypeSignatureBuilder(Map<String, JavaType.FullyQualified> jvmTypes) {
        this.jvmTypes = jvmTypes;
    }
}

