/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class UseCollectionInterfaces
extends Recipe {
    public static Map<String, String> rspecRulesReplaceTypeMap = new HashMap<String, String>();

    public String getDisplayName() {
        return "Use `Collection` interfaces";
    }

    public String getDescription() {
        return "Use `Deque`, `List`, `Map`, `ConcurrentMap`, `Queue`, and `Set` instead of implemented collections. Replaces the return type of public method declarations and the variable type public variable declarations.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1319");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified(type);
                    if (fq == null || !rspecRulesReplaceTypeMap.containsKey(fq.getFullyQualifiedName())) continue;
                    return super.visitJavaSourceFile(cu, executionContext);
                }
                return cu;
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                JavaType.FullyQualified newType;
                JavaType.FullyQualified originalType;
                J m = super.visitMethodDeclaration(method, executionContext);
                if (((J.MethodDeclaration)m).hasModifier(J.Modifier.Type.Public) && ((J.MethodDeclaration)m).getReturnTypeExpression() != null && (originalType = TypeUtils.asFullyQualified(((J.MethodDeclaration)m).getReturnTypeExpression().getType())) != null && rspecRulesReplaceTypeMap.containsKey(originalType.getFullyQualifiedName()) && (newType = TypeUtils.asFullyQualified(JavaType.buildType(rspecRulesReplaceTypeMap.get(originalType.getFullyQualifiedName())))) != null) {
                    Expression typeExpression;
                    this.maybeRemoveImport(originalType);
                    this.maybeAddImport(newType);
                    if (((J.MethodDeclaration)m).getReturnTypeExpression() instanceof J.Identifier) {
                        typeExpression = new J.Identifier(Tree.randomId(), ((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix(), Markers.EMPTY, newType.getClassName(), newType, null);
                    } else {
                        J.ParameterizedType parameterizedType = (J.ParameterizedType)((J.MethodDeclaration)m).getReturnTypeExpression();
                        J.Identifier returnType = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, newType.getClassName(), newType, null);
                        typeExpression = parameterizedType.withClazz(returnType);
                    }
                    m = ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)((Object)typeExpression));
                }
                return m;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                JavaType.FullyQualified newType;
                J mv = super.visitVariableDeclarations(multiVariable, executionContext);
                JavaType.FullyQualified originalType = TypeUtils.asFullyQualified(((J.VariableDeclarations)mv).getType());
                if (multiVariable.hasModifier(J.Modifier.Type.Public) && originalType != null && rspecRulesReplaceTypeMap.containsKey(originalType.getFullyQualifiedName()) && (newType = TypeUtils.asFullyQualified(JavaType.buildType(rspecRulesReplaceTypeMap.get(originalType.getFullyQualifiedName())))) != null) {
                    Expression typeExpression;
                    this.maybeRemoveImport(originalType);
                    this.maybeAddImport(newType);
                    if (((J.VariableDeclarations)mv).getTypeExpression() == null) {
                        typeExpression = null;
                    } else if (((J.VariableDeclarations)mv).getTypeExpression() instanceof J.Identifier) {
                        typeExpression = new J.Identifier(((J.VariableDeclarations)mv).getTypeExpression().getId(), ((J.VariableDeclarations)mv).getTypeExpression().getPrefix(), Markers.EMPTY, newType.getClassName(), newType, null);
                    } else {
                        J.ParameterizedType parameterizedType = (J.ParameterizedType)((J.VariableDeclarations)mv).getTypeExpression();
                        J.Identifier returnType = new J.Identifier(((J.VariableDeclarations)mv).getTypeExpression().getId(), Space.EMPTY, Markers.EMPTY, newType.getClassName(), newType, null);
                        typeExpression = parameterizedType.withClazz(returnType);
                    }
                    mv = ((J.VariableDeclarations)mv).withTypeExpression((TypeTree)((Object)typeExpression));
                    mv = ((J.VariableDeclarations)mv).withVariables(ListUtils.map(((J.VariableDeclarations)mv).getVariables(), var -> {
                        JavaType.FullyQualified varType = TypeUtils.asFullyQualified(var.getType());
                        if (varType != null && !varType.equals(newType)) {
                            return var.withType(newType).withName(var.getName().withType(newType));
                        }
                        return var;
                    }));
                }
                return mv;
            }
        };
    }

    static {
        rspecRulesReplaceTypeMap.put("java.util.ArrayDeque", "java.util.Deque");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentLinkedDeque", "java.util.Deque");
        rspecRulesReplaceTypeMap.put("java.util.AbstractList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.AbstractSequentialList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.ArrayList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.CopyOnWriteArrayList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.AbstractMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.EnumMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.HashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.Hashtable", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.IdentityHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.LinkedHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.WeakHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentMap");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentSkipListMap", "java.util.concurrent.ConcurrentMap");
        rspecRulesReplaceTypeMap.put("java.util.AbstractQueue", "java.util.Queue");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentLinkedQueue", "java.util.Queue");
        rspecRulesReplaceTypeMap.put("java.util.AbstractSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.EnumSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.HashSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.LinkedHashSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.CopyOnWriteArraySet", "java.util.Set");
    }
}

