/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class SimplifyConsecutiveAssignments
extends Recipe {
    public String getDisplayName() {
        return "Simplify consecutive assignments";
    }

    public String getDescription() {
        return "Combine consecutive assignments into a single statement where possible.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate combinedAssignment = JavaTemplate.builder(() -> (this).getCursor(), "o = (#{any()} #{} #{any()});").build();

            @Override
            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J b2;
                AtomicInteger skip;
                J b;
                J combined = b = super.visitBlock(block, ctx);
                do {
                    b2 = b = combined;
                    skip = new AtomicInteger(-1);
                } while ((combined = ((J.Block)b).withStatements(ListUtils.map(((J.Block)b).getStatements(), (arg_0, arg_1) -> this.lambda$visitBlock$0(skip, (J.Block)b2, arg_0, arg_1)))) != b);
                if (b != block) {
                    b = (J.Block)new UnnecessaryParenthesesVisitor(Checkstyle.unnecessaryParentheses()).visitNonNull(b, ctx, this.getCursor());
                }
                return b;
            }

            @Nullable
            private String numericVariableName(Statement s) {
                if (s instanceof J.Assignment) {
                    return this.singleVariableName(((J.Assignment)s).getVariable());
                }
                if (s instanceof J.VariableDeclarations) {
                    J.VariableDeclarations.NamedVariable firstNamedVariable = ((J.VariableDeclarations)s).getVariables().get(0);
                    return firstNamedVariable.getInitializer() == null ? null : this.singleVariableName(firstNamedVariable.getName());
                }
                return null;
            }

            @Nullable
            private Expression numericVariableAccumulation(Statement s, String name) {
                J.AssignmentOperation assignOp;
                if (s instanceof J.Unary) {
                    if (name.equals(this.singleVariableName(((J.Unary)s).getExpression()))) {
                        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, 1, "1", null, JavaType.Primitive.Int);
                    }
                } else if (s instanceof J.AssignmentOperation && name.equals(this.singleVariableName((assignOp = (J.AssignmentOperation)s).getVariable()))) {
                    return assignOp.getAssignment();
                }
                return null;
            }

            @Nullable
            private String numericVariableOperator(Statement s, String name) {
                J.AssignmentOperation assignOp;
                if (s instanceof J.Unary) {
                    if (name.equals(this.singleVariableName(((J.Unary)s).getExpression()))) {
                        switch (((J.Unary)s).getOperator()) {
                            case PreDecrement: 
                            case PostDecrement: {
                                return "-";
                            }
                            case PreIncrement: 
                            case PostIncrement: {
                                return "+";
                            }
                        }
                    }
                } else if (s instanceof J.AssignmentOperation && name.equals(this.singleVariableName((assignOp = (J.AssignmentOperation)s).getVariable()))) {
                    switch (assignOp.getOperator()) {
                        case Addition: {
                            return "+";
                        }
                        case BitAnd: {
                            return "&";
                        }
                        case BitOr: {
                            return "|";
                        }
                        case BitXor: {
                            return "^";
                        }
                        case Division: {
                            return "/";
                        }
                        case LeftShift: {
                            return "<<";
                        }
                        case Modulo: {
                            return "%";
                        }
                        case Multiplication: {
                            return "*";
                        }
                        case RightShift: {
                            return ">>";
                        }
                        case Subtraction: {
                            return "-";
                        }
                        case UnsignedRightShift: {
                            return ">>>";
                        }
                    }
                }
                return null;
            }

            @Nullable
            private String singleVariableName(Expression e) {
                JavaType.Primitive type = TypeUtils.asPrimitive(e.getType());
                return type != null && type.isNumeric() && e instanceof J.Identifier ? ((J.Identifier)e).getSimpleName() : null;
            }

            private Statement combine(Statement s, String op, Expression right) {
                if (s instanceof J.Assignment) {
                    J.Assignment assign = (J.Assignment)s;
                    J.Assignment after = (J.Assignment)s.withTemplate(this.combinedAssignment, s.getCoordinates().replace(), assign.getAssignment(), op, right);
                    return assign.withAssignment(after.getAssignment());
                }
                if (s instanceof J.VariableDeclarations) {
                    J.VariableDeclarations variables = (J.VariableDeclarations)s;
                    J.Assignment after = (J.Assignment)s.withTemplate(this.combinedAssignment, s.getCoordinates().replace(), variables.getVariables().get(0).getInitializer(), op, right);
                    return variables.withVariables(ListUtils.map(variables.getVariables(), (i, namedVar) -> i == 0 ? namedVar.withInitializer(after.getAssignment()) : namedVar));
                }
                throw new UnsupportedOperationException("Attempted to combine assignments into a single statement with type " + s.getClass().getSimpleName());
            }

            private /* synthetic */ Statement lambda$visitBlock$0(AtomicInteger skip, J.Block b2, Integer i, Statement stat) {
                if (skip.get() == i.intValue()) {
                    return null;
                }
                String name = this.numericVariableName(stat);
                if (name != null) {
                    Statement nextStatement = b2.getStatements().get(i + 1);
                    Expression acc = this.numericVariableAccumulation(nextStatement, name);
                    String op = this.numericVariableOperator(nextStatement, name);
                    if (acc != null && op != null) {
                        skip.set(i + 1);
                        return this.combine(stat, op, acc);
                    }
                }
                return stat;
            }
        };
    }
}

