/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.ClassgraphTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;

public final class JavaSourceSet
implements Marker {
    private final UUID id;
    private final String name;
    private final List<JavaType.FullyQualified> classpath;

    public static JavaSourceSet build(String sourceSetName, Iterable<Path> classpath, JavaTypeCache typeCache, ExecutionContext ctx) {
        Map<String, JavaType.FullyQualified> jvmClasses = JavaSourceSet.jvmClasses(typeCache, ctx);
        ArrayList<JavaType.FullyQualified> fqns = new ArrayList<JavaType.FullyQualified>(jvmClasses.values());
        ClassgraphTypeMapping typeMapping = new ClassgraphTypeMapping(typeCache, jvmClasses);
        if (classpath.iterator().hasNext()) {
            try (ScanResult scanResult = new ClassGraph().overrideClasspath(classpath).enableAnnotationInfo().enableMemoryMapping().enableClassInfo().enableMethodInfo().enableFieldInfo().ignoreClassVisibility().ignoreFieldVisibility().ignoreMethodVisibility().scan();){
                for (ClassInfo classInfo : scanResult.getAllClasses()) {
                    try {
                        fqns.add(typeMapping.type(classInfo));
                    }
                    catch (Exception e) {
                        ctx.getOnError().accept(e);
                    }
                }
            }
        }
        return new JavaSourceSet(Tree.randomId(), sourceSetName, fqns);
    }

    private static Map<String, JavaType.FullyQualified> jvmClasses(JavaTypeCache javaTypeCache, ExecutionContext ctx) {
        boolean java8 = System.getProperty("java.version").startsWith("1.8");
        try (ScanResult scanResult = new ClassGraph().enableMemoryMapping().enableAnnotationInfo().enableClassInfo().enableMethodInfo().enableFieldInfo().enableSystemJarsAndModules().acceptPackages(new String[]{"java"}).ignoreClassVisibility().ignoreFieldVisibility().ignoreMethodVisibility().scan();){
            ClassInfoList classInfos = scanResult.getAllClasses();
            ClassgraphTypeMapping builder = new ClassgraphTypeMapping(javaTypeCache, Collections.emptyMap());
            HashMap<String, JavaType.FullyQualified> fqns = new HashMap<String, JavaType.FullyQualified>(classInfos.size());
            for (ClassInfo classInfo : classInfos) {
                try {
                    fqns.put(classInfo.getName(), builder.type(classInfo));
                }
                catch (Exception e) {
                    ctx.getOnError().accept(e);
                }
            }
            HashMap<String, JavaType.FullyQualified> hashMap = fqns;
            return hashMap;
        }
    }

    public JavaSourceSet(UUID id, String name, List<JavaType.FullyQualified> classpath) {
        this.id = id;
        this.name = name;
        this.classpath = classpath;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<JavaType.FullyQualified> getClasspath() {
        return this.classpath;
    }

    @NonNull
    public String toString() {
        return "JavaSourceSet(id=" + this.getId() + ", name=" + this.getName() + ", classpath=" + this.getClasspath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaSourceSet)) {
            return false;
        }
        JavaSourceSet other = (JavaSourceSet)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public JavaSourceSet withId(UUID id) {
        return this.id == id ? this : new JavaSourceSet(id, this.name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withName(String name) {
        return this.name == name ? this : new JavaSourceSet(this.id, name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withClasspath(List<JavaType.FullyQualified> classpath) {
        return this.classpath == classpath ? this : new JavaSourceSet(this.id, this.name, classpath);
    }
}

