/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ArrayTypeSignature;
import io.github.classgraph.BaseTypeSignature;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClassRefOrTypeVariableSignature;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.ReferenceTypeSignature;
import io.github.classgraph.TypeArgument;
import io.github.classgraph.TypeParameter;
import io.github.classgraph.TypeVariableSignature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeMapping;
import org.openrewrite.java.internal.ClassgraphJavaTypeSignatureBuilder;
import org.openrewrite.java.internal.JavaReflectionTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

public class ClassgraphTypeMapping
implements JavaTypeMapping<ClassInfo> {
    private final ClassgraphJavaTypeSignatureBuilder signatureBuilder;
    private final JavaTypeCache typeCache;
    private final JavaReflectionTypeMapping reflectionTypeMapping;
    private final Map<String, JavaType.FullyQualified> jvmTypes;

    public ClassgraphTypeMapping(JavaTypeCache typeCache, Map<String, JavaType.FullyQualified> jvmTypes) {
        this.typeCache = typeCache;
        this.reflectionTypeMapping = new JavaReflectionTypeMapping(typeCache);
        this.jvmTypes = jvmTypes;
        this.signatureBuilder = new ClassgraphJavaTypeSignatureBuilder(jvmTypes);
    }

    public JavaType.FullyQualified type(@Nullable ClassInfo aClass) {
        ClassTypeSignature typeSignature;
        if (aClass == null) {
            return JavaType.Unknown.getInstance();
        }
        String className = aClass.getName();
        JavaType.FullyQualified clazz = (JavaType.FullyQualified)this.typeCache.get(className);
        if (clazz == null) {
            JavaType.FullyQualified.Kind kind = aClass.isInterface() ? JavaType.FullyQualified.Kind.Interface : (aClass.isEnum() ? JavaType.FullyQualified.Kind.Enum : (aClass.isAnnotation() ? JavaType.FullyQualified.Kind.Annotation : JavaType.FullyQualified.Kind.Class));
            clazz = new JavaType.Class(null, this.getFlagsFromClass(aClass), className, kind, null, null, null, null, null, null);
            this.typeCache.put(className, clazz);
            ClassInfo superclassInfo = aClass.getSuperclass();
            JavaType.FullyQualified supertype = superclassInfo == null ? (JavaType.FullyQualified)this.reflectionTypeMapping.type((Type)((Object)Object.class)) : this.type(superclassInfo);
            JavaType.FullyQualified owner = aClass.getOuterClasses().isEmpty() ? null : this.type((ClassInfo)aClass.getOuterClasses().get(0));
            ArrayList<JavaType.FullyQualified> annotations = null;
            AnnotationInfoList classGraphAnnotations = aClass.getAnnotationInfo();
            if (!classGraphAnnotations.isEmpty()) {
                annotations = new ArrayList<JavaType.FullyQualified>(classGraphAnnotations.size());
                for (AnnotationInfo annotationInfo : classGraphAnnotations) {
                    annotations.add(this.type(annotationInfo.getClassInfo()));
                }
            }
            ArrayList<JavaType.FullyQualified> interfaces = null;
            ClassInfoList classGraphInterfaces = aClass.getInterfaces().directOnly();
            if (!classGraphInterfaces.isEmpty()) {
                interfaces = new ArrayList<JavaType.FullyQualified>(classGraphInterfaces.size());
                for (ClassInfo anInterface : classGraphInterfaces) {
                    interfaces.add(this.type(anInterface));
                }
            }
            ArrayList<JavaType.Variable> variables = null;
            FieldInfoList classGraphVariables = aClass.getDeclaredFieldInfo();
            if (!classGraphVariables.isEmpty()) {
                variables = new ArrayList<JavaType.Variable>(classGraphVariables.size());
                for (FieldInfo fieldInfo : classGraphVariables) {
                    if (fieldInfo.isSynthetic() || aClass.getName().equals("java.lang.String") && fieldInfo.getName().equals("serialPersistentFields")) continue;
                    JavaType.Variable variable = this.variableType(fieldInfo);
                    variables.add(variable);
                }
            }
            ArrayList<JavaType.Method> methods = null;
            MethodInfoList methodInfos = aClass.getDeclaredMethodAndConstructorInfo();
            if (!methodInfos.isEmpty()) {
                methods = new ArrayList<JavaType.Method>(methodInfos.size());
                for (MethodInfo methodInfo : methodInfos) {
                    if (methodInfo.isBridge() || methodInfo.isSynthetic()) continue;
                    methods.add(this.methodType(methodInfo));
                }
            }
            ((JavaType.Class)clazz).unsafeSet(supertype, owner, annotations, interfaces, variables, methods);
        }
        if ((typeSignature = aClass.getTypeSignature()) == null || typeSignature.getTypeParameters() == null || typeSignature.getTypeParameters().isEmpty()) {
            return clazz;
        }
        String signature = this.signatureBuilder.signature(aClass.getTypeSignature());
        JavaType.Parameterized parameterized = (JavaType.Parameterized)this.typeCache.get(signature);
        if (parameterized != null) {
            return parameterized;
        }
        parameterized = new JavaType.Parameterized(null, clazz, null);
        this.typeCache.put(signature, parameterized);
        ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(typeSignature.getTypeParameters().size());
        for (TypeParameter tParam : typeSignature.getTypeParameters()) {
            typeParameters.add(this.type((HierarchicalTypeSignature)tParam));
        }
        parameterized.unsafeSet(clazz, typeParameters);
        return parameterized;
    }

    @Override
    private JavaType type(HierarchicalTypeSignature typeSignature) {
        String signature = this.signatureBuilder.signature(typeSignature);
        JavaType existing = (JavaType)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        if (typeSignature instanceof ClassRefTypeSignature) {
            return this.classType((ClassRefTypeSignature)typeSignature, signature);
        }
        if (typeSignature instanceof ClassTypeSignature) {
            return this.classType((ClassTypeSignature)typeSignature, signature);
        }
        if (typeSignature instanceof ArrayTypeSignature) {
            return this.array((ArrayTypeSignature)typeSignature, signature);
        }
        if (typeSignature instanceof BaseTypeSignature) {
            return JavaType.Primitive.fromKeyword(((BaseTypeSignature)typeSignature).getTypeStr());
        }
        if (typeSignature instanceof TypeVariableSignature) {
            return this.generic((TypeVariableSignature)typeSignature, signature);
        }
        if (typeSignature instanceof TypeArgument) {
            return this.generic((TypeArgument)typeSignature, signature);
        }
        if (typeSignature instanceof TypeParameter) {
            return this.generic((TypeParameter)typeSignature, signature);
        }
        throw new UnsupportedOperationException("Unexpected signature type " + typeSignature.getClass().getName());
    }

    private JavaType.Variable variableType(FieldInfo fieldInfo) {
        String signature = this.signatureBuilder.variableSignature(fieldInfo);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable variable = new JavaType.Variable(null, this.getFlagsFromField(fieldInfo), fieldInfo.getName(), null, null, null);
        this.typeCache.put(signature, variable);
        JavaType.FullyQualified owner = this.type(fieldInfo.getClassInfo());
        List<JavaType.FullyQualified> annotations = Collections.emptyList();
        if (!fieldInfo.getAnnotationInfo().isEmpty()) {
            annotations = new ArrayList(fieldInfo.getAnnotationInfo().size());
            for (AnnotationInfo annotationInfo : fieldInfo.getAnnotationInfo()) {
                annotations.add(this.type(annotationInfo.getClassInfo()));
            }
        }
        variable.unsafeSet(owner instanceof JavaType.Parameterized ? ((JavaType.Parameterized)owner).getType() : owner, this.type((HierarchicalTypeSignature)fieldInfo.getTypeDescriptor()), annotations);
        return variable;
    }

    /*
     * WARNING - void declaration
     */
    private JavaType.Method methodType(MethodInfo methodInfo) {
        void var10_15;
        JavaType.FullyQualified type;
        long flags = methodInfo.getModifiers();
        String signature = this.signatureBuilder.methodSignature(methodInfo);
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        ArrayList<String> paramNames = null;
        if (methodInfo.getParameterInfo().length > 0) {
            paramNames = new ArrayList<String>(methodInfo.getParameterInfo().length);
            for (MethodParameterInfo methodParameterInfo : methodInfo.getParameterInfo()) {
                paramNames.add(methodParameterInfo.getName());
            }
        }
        JavaType.Method method = new JavaType.Method(null, this.getFlagsFromMethod(methodInfo), null, methodInfo.isConstructor() ? "<constructor>" : methodInfo.getName(), null, paramNames, null, null, null);
        this.typeCache.put(signature, method);
        JavaType returnType = methodInfo.getTypeSignature() == null ? this.type((HierarchicalTypeSignature)methodInfo.getTypeDescriptor().getResultType()) : this.type((HierarchicalTypeSignature)methodInfo.getTypeSignature().getResultType());
        ArrayList<JavaType> parameterTypes = new ArrayList<JavaType>(methodInfo.getParameterInfo().length);
        for (MethodParameterInfo methodParameterInfo : methodInfo.getParameterInfo()) {
            parameterTypes.add(methodParameterInfo.getTypeSignature() == null ? this.type((HierarchicalTypeSignature)methodParameterInfo.getTypeDescriptor()) : this.type((HierarchicalTypeSignature)methodParameterInfo.getTypeSignature()));
        }
        Object var10_13 = null;
        if (!methodInfo.getTypeDescriptor().getThrowsSignatures().isEmpty()) {
            ArrayList<JavaType.FullyQualified> arrayList = new ArrayList<JavaType.FullyQualified>(methodInfo.getTypeDescriptor().getThrowsSignatures().size());
            for (ClassRefOrTypeVariableSignature throwsSignature : methodInfo.getTypeDescriptor().getThrowsSignatures()) {
                if (!(throwsSignature instanceof ClassRefTypeSignature)) continue;
                arrayList.add(this.type(((ClassRefTypeSignature)throwsSignature).getClassInfo()));
            }
        }
        ArrayList<JavaType.FullyQualified> annotations = null;
        if (!methodInfo.getAnnotationInfo().isEmpty()) {
            annotations = new ArrayList<JavaType.FullyQualified>(methodInfo.getAnnotationInfo().size());
            for (AnnotationInfo annotationInfo : methodInfo.getAnnotationInfo()) {
                annotations.add(this.type(annotationInfo.getClassInfo()));
            }
        }
        JavaType.FullyQualified declaringType = (type = this.type(methodInfo.getClassInfo())) instanceof JavaType.Parameterized ? ((JavaType.Parameterized)type).getType() : type;
        method.unsafeSet(declaringType, methodInfo.isConstructor() ? declaringType : returnType, parameterTypes, (List<JavaType.FullyQualified>)var10_15, annotations);
        return method;
    }

    private JavaType.GenericTypeVariable generic(TypeParameter typeParameter, String signature) {
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, typeParameter.getName(), JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, gtv);
        List<JavaType> bounds = null;
        if (typeParameter.getClassBound() != null) {
            JavaType mappedBound = this.type((HierarchicalTypeSignature)typeParameter.getClassBound());
            if (typeParameter.getClassBound() instanceof ClassRefTypeSignature) {
                ReferenceTypeSignature bound = typeParameter.getClassBound();
                ClassRefTypeSignature classBound = (ClassRefTypeSignature)bound;
                if (!"java.lang.Object".equals(classBound.getFullyQualifiedClassName())) {
                    bounds = Collections.singletonList(mappedBound);
                }
            } else {
                bounds = Collections.singletonList(mappedBound);
            }
        } else if (typeParameter.getInterfaceBounds() != null && !typeParameter.getInterfaceBounds().isEmpty()) {
            bounds = new ArrayList<JavaType>(typeParameter.getInterfaceBounds().size());
            for (ReferenceTypeSignature interfaceBound : typeParameter.getInterfaceBounds()) {
                bounds.add(this.type((HierarchicalTypeSignature)interfaceBound));
            }
        }
        gtv.unsafeSet(bounds == null ? JavaType.GenericTypeVariable.Variance.INVARIANT : JavaType.GenericTypeVariable.Variance.COVARIANT, bounds);
        return gtv;
    }

    private JavaType.GenericTypeVariable generic(TypeVariableSignature typeVariableSignature, String signature) {
        try {
            return (JavaType.GenericTypeVariable)this.type((HierarchicalTypeSignature)typeVariableSignature.resolve());
        }
        catch (IllegalArgumentException ignored) {
            JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, typeVariableSignature.getName(), JavaType.GenericTypeVariable.Variance.INVARIANT, null);
            this.typeCache.put(signature, gtv);
            return gtv;
        }
    }

    private JavaType generic(TypeArgument typeArgument, String signature) {
        JavaType.GenericTypeVariable gtv;
        List<JavaType> bounds = null;
        switch (typeArgument.getWildcard()) {
            case NONE: {
                return this.type((HierarchicalTypeSignature)typeArgument.getTypeSignature());
            }
            case EXTENDS: {
                gtv = new JavaType.GenericTypeVariable(null, "?", JavaType.GenericTypeVariable.Variance.COVARIANT, null);
                this.typeCache.put(signature, gtv);
                JavaType mappedBound = this.type((HierarchicalTypeSignature)typeArgument.getTypeSignature());
                if (mappedBound instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)mappedBound).getFullyQualifiedName().equals("java.lang.Object")) break;
                bounds = Collections.singletonList(mappedBound);
                break;
            }
            case SUPER: {
                gtv = new JavaType.GenericTypeVariable(null, "?", JavaType.GenericTypeVariable.Variance.CONTRAVARIANT, null);
                this.typeCache.put(signature, gtv);
                JavaType mappedBound = this.type((HierarchicalTypeSignature)typeArgument.getTypeSignature());
                if (mappedBound instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)mappedBound).getFullyQualifiedName().equals("java.lang.Object")) break;
                bounds = Collections.singletonList(mappedBound);
                break;
            }
            default: {
                gtv = new JavaType.GenericTypeVariable(null, "?", JavaType.GenericTypeVariable.Variance.INVARIANT, null);
                this.typeCache.put(signature, gtv);
            }
        }
        gtv.unsafeSet((bounds = ListUtils.map(bounds, b -> b instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)b).getFullyQualifiedName().equals("java.lang.Object") ? null : b)) == null || bounds.isEmpty() ? JavaType.GenericTypeVariable.Variance.INVARIANT : gtv.getVariance(), bounds);
        return gtv;
    }

    private JavaType classType(ClassRefTypeSignature classRefSignature, String signature) {
        JavaType.FullyQualified type;
        ClassInfo classInfo = classRefSignature.getClassInfo();
        if (classInfo == null) {
            String className = classRefSignature.getBaseClassName();
            type = this.jvmTypes.get(className);
            if (type == null) {
                if (className.equals("java.lang.Object")) {
                    type = (JavaType.FullyQualified)this.reflectionTypeMapping.type((Type)((Object)Object.class));
                } else {
                    type = JavaType.Unknown.getInstance();
                    this.typeCache.put(className, type);
                }
            }
        } else {
            type = this.type(classInfo);
        }
        if (!classRefSignature.getTypeArguments().isEmpty()) {
            JavaType existing = (JavaType)this.typeCache.get(signature);
            if (existing != null) {
                return existing;
            }
            JavaType.Parameterized parameterized = new JavaType.Parameterized(null, type instanceof JavaType.Parameterized ? ((JavaType.Parameterized)type).getType() : type, null);
            this.typeCache.put(signature, parameterized);
            ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(classRefSignature.getTypeArguments().size());
            for (TypeArgument typeArgument : classRefSignature.getTypeArguments()) {
                typeParameters.add(this.type((HierarchicalTypeSignature)typeArgument));
            }
            parameterized.unsafeSet(parameterized.getType(), typeParameters);
            return parameterized;
        }
        return type;
    }

    private JavaType classType(ClassTypeSignature classSignature, String signature) {
        try {
            Method getClassInfo = classSignature.getClass().getDeclaredMethod("getClassInfo", new Class[0]);
            getClassInfo.setAccessible(true);
            ClassInfo classInfo = (ClassInfo)getClassInfo.invoke((Object)classSignature, new Object[0]);
            if (classInfo == null) {
                Method getClassName = classSignature.getClass().getDeclaredMethod("getClassName", new Class[0]);
                getClassName.setAccessible(true);
                String className = (String)getClassName.invoke((Object)classSignature, new Object[0]);
                JavaType fallback = this.jvmTypes.get(className);
                if (fallback == null) {
                    fallback = className.equals("java.lang.Object") ? this.reflectionTypeMapping.type((Type)((Object)Object.class)) : JavaType.Unknown.getInstance();
                }
                this.typeCache.put(signature, fallback);
                return fallback;
            }
            JavaType.Class clazz = (JavaType.Class)this.type(classInfo);
            if (classSignature.getTypeParameters().isEmpty()) {
                return clazz;
            }
            JavaType.Parameterized parameterized = new JavaType.Parameterized(null, null, null);
            this.typeCache.put(signature, parameterized);
            ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(classSignature.getTypeParameters().size());
            for (TypeParameter typeParameter : classSignature.getTypeParameters()) {
                typeParameters.add(this.type((HierarchicalTypeSignature)typeParameter));
            }
            parameterized.unsafeSet(clazz, typeParameters);
            return parameterized;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private JavaType array(ArrayTypeSignature typeSignature, String signature) {
        JavaType.Array arr = new JavaType.Array(null, null);
        this.typeCache.put(signature, arr);
        arr.unsafeSet(this.type((HierarchicalTypeSignature)typeSignature.getNestedType()));
        return arr;
    }

    private long getFlagsFromClass(ClassInfo classInfo) {
        return classInfo.getModifiers();
    }

    private long getFlagsFromMethod(MethodInfo methodInfo) {
        long flags = methodInfo.getModifiers();
        if (methodInfo.isDefault()) {
            flags |= Flag.Default.getBitMask();
        }
        if (methodInfo.getClassInfo().isInterface() && !methodInfo.isAbstract()) {
            flags |= Flag.Abstract.getBitMask();
        }
        if (methodInfo.isVarArgs()) {
            flags &= Flag.Transient.getBitMask() ^ 0xFFFFFFFFFFFFFFFFL;
            flags |= Flag.Varargs.getBitMask();
        }
        return flags;
    }

    private long getFlagsFromField(FieldInfo fieldInfo) {
        return fieldInfo.getModifiers();
    }
}

