/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NewStringBuilderBufferWithCharArgument
extends Recipe {
    public String getDisplayName() {
        return "Change StringBuilder and StringBuffer character constructor arg to String";
    }

    public String getDescription() {
        return "Instantiating a `StringBuilder` or a `StringBuffer` with a `Character` results in the `int` representation of the character being used for the initial size.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1317");
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesType("java.lang.StringBuilder"));
                this.doAfterVisit(new UsesType("java.lang.StringBuffer"));
                return cu;
            }
        };
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J nc = super.visitNewClass(newClass, executionContext);
                if ((TypeUtils.isOfClassType(((J.NewClass)nc).getType(), "java.lang.StringBuilder") || TypeUtils.isOfClassType(((J.NewClass)nc).getType(), "java.lang.StringBuffer")) && ((J.NewClass)nc).getArguments() != null && ((J.NewClass)nc).getArguments().get(0).getType() == JavaType.Primitive.Char) {
                    nc = ((J.NewClass)nc).withArguments(ListUtils.mapFirst(((J.NewClass)nc).getArguments(), arg -> {
                        J.Literal l = (J.Literal)arg;
                        if ((l = l.withType(JavaType.buildType("String"))).getValueSource() != null) {
                            l = l.withValueSource(l.getValueSource().replace("'", "\""));
                        }
                        return l;
                    }));
                }
                return nc;
            }
        };
    }
}

