/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.IdentityHashMap;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Range;

@Incubating(since="7.18.0")
public class UpdateSourcePositions
extends Recipe {
    public String getDisplayName() {
        return "Update source positions";
    }

    public String getDescription() {
        return "Calculate start position and length for every AST element.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        final IdentityHashMap positionMap = new IdentityHashMap();
        final PositionPrintOutputCapture ppoc = new PositionPrintOutputCapture();
        final JavaPrinter<ExecutionContext> printer = new JavaPrinter<ExecutionContext>(){
            final JavaPrinter<ExecutionContext> spacePrinter = new JavaPrinter();

            @Nullable
            public J visit(@Nullable Tree tree, PrintOutputCapture<ExecutionContext> outputCapture) {
                if (tree == null) {
                    return null;
                }
                J t = (J)tree;
                PositionPrintOutputCapture prefix = new PositionPrintOutputCapture(ppoc.pos, ppoc.line, ppoc.column);
                this.spacePrinter.visitSpace(t.getPrefix(), Space.Location.ANY, prefix);
                Range.Position startPosition = new Range.Position(prefix.pos, prefix.line, prefix.column);
                t = (J)super.visit(tree, outputCapture);
                Range.Position endPosition = new Range.Position(ppoc.pos, ppoc.line, ppoc.column);
                positionMap.put(t, new Range(Tree.randomId(), startPosition, endPosition));
                return t;
            }

            @Override
            protected void visitModifier(J.Modifier modifier, PrintOutputCapture<ExecutionContext> p) {
                if (modifier == null) {
                    return;
                }
                PositionPrintOutputCapture prefix = new PositionPrintOutputCapture(ppoc.pos, ppoc.line, ppoc.column);
                this.spacePrinter.visitSpace(modifier.getPrefix(), Space.Location.ANY, prefix);
                Range.Position startPosition = new Range.Position(prefix.pos, prefix.line, prefix.column);
                super.visitModifier(modifier, p);
                Range.Position endPosition = new Range.Position(ppoc.pos, ppoc.line, ppoc.column);
                positionMap.put(modifier, new Range(Tree.randomId(), startPosition, endPosition));
            }
        };
        return new JavaVisitor<ExecutionContext>(){
            boolean firstVisit = true;

            @Nullable
            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                if (this.firstVisit) {
                    tree = printer.visit(tree, (Object)ppoc);
                    this.firstVisit = false;
                }
                Range range = (Range)positionMap.get(tree);
                Object t = ((J)tree).withMarkers(((J)tree).getMarkers().add((Marker)range));
                return (J)super.visit(t, (Object)ctx);
            }
        };
    }

    private static class PositionPrintOutputCapture
    extends PrintOutputCapture<ExecutionContext> {
        int pos = 0;
        int line = 1;
        int column = 0;
        private boolean lineBoundary;

        public PositionPrintOutputCapture() {
            super((Object)new InMemoryExecutionContext());
        }

        public PositionPrintOutputCapture(int pos, int line, int column) {
            this();
            this.pos = pos;
            this.line = line;
            this.column = column;
        }

        public PrintOutputCapture<ExecutionContext> append(char c) {
            ++this.pos;
            if (this.lineBoundary) {
                ++this.line;
                this.column = 0;
                this.lineBoundary = false;
            } else {
                ++this.column;
            }
            if (c == '\n') {
                this.lineBoundary = true;
            }
            return super.append(c);
        }

        public PrintOutputCapture<ExecutionContext> append(@Nullable String text) {
            if (text != null) {
                if (this.lineBoundary) {
                    ++this.line;
                    this.column = 0;
                    this.lineBoundary = false;
                }
                this.pos += text.length();
                long numberOfLines = text.chars().filter(c -> c == 10).count();
                if (numberOfLines > 0L) {
                    this.line = (int)((long)this.line + numberOfLines);
                    this.column = text.length() - text.lastIndexOf(10);
                } else {
                    this.column += text.length();
                }
            }
            return super.append(text);
        }
    }
}

