/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.openrewrite.java.style.ImportLayoutStyle;

class Serializer
extends JsonSerializer<ImportLayoutStyle> {
    Serializer() {
    }

    public void serialize(ImportLayoutStyle value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("@c", ImportLayoutStyle.class.getName());
        gen.writeNumberField("classCountToUseStarImport", value.getClassCountToUseStarImport());
        gen.writeNumberField("nameCountToUseStarImport", value.getNameCountToUseStarImport());
        String[] blocks = (String[])value.getLayout().stream().map(block -> {
            if (block instanceof ImportLayoutStyle.Block.BlankLines) {
                return "<blank line>";
            }
            if (block instanceof ImportLayoutStyle.Block.AllOthers) {
                return "import " + (((ImportLayoutStyle.Block.AllOthers)block).isStatic() ? "static " : "") + "all other imports";
            }
            if (block instanceof ImportLayoutStyle.Block.ImportPackage) {
                ImportLayoutStyle.Block.ImportPackage importPackage = (ImportLayoutStyle.Block.ImportPackage)block;
                return (importPackage.isStatic() ? "static " : "") + "import " + importPackage.getPackageWildcard();
            }
            return new UnsupportedOperationException("Unknown block type " + block.getClass().getName());
        }).toArray(String[]::new);
        gen.writeArrayFieldStart("layout");
        gen.writeArray(blocks, 0, blocks.length);
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

