/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.UnnecessaryParenthesesStyle;
import org.openrewrite.java.tree.J;

@Incubating(since="7.0.0")
public class UnnecessaryParentheses
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary parentheses";
    }

    public String getDescription() {
        return "Remove unnecessary parentheses.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UnnecessaryParenthesesFromCompilationUnitStyle();
    }

    private static class UnnecessaryParenthesesFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private UnnecessaryParenthesesFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            UnnecessaryParenthesesStyle style = (UnnecessaryParenthesesStyle)cu.getStyle(UnnecessaryParenthesesStyle.class);
            if (style == null) {
                style = IntelliJ.unnecessaryParentheses();
            }
            this.doAfterVisit(new UnnecessaryParenthesesVisitor(style));
            return super.visitCompilationUnit(cu, executionContext);
        }
    }
}

