/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ChangeFieldType<P>
extends JavaIsoVisitor<P> {
    private final JavaType.Class type;
    private final String targetType;

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        JavaType.Class typeAsClass = multiVariable.getTypeAsClass();
        J mv = super.visitVariableDeclarations(multiVariable, (Object)p);
        if (typeAsClass != null && typeAsClass.equals(this.type)) {
            JavaType.Class type = JavaType.Class.build(this.targetType);
            this.maybeAddImport(this.targetType);
            this.maybeRemoveImport(typeAsClass);
            mv = ((J.VariableDeclarations)mv).withTypeExpression(((J.VariableDeclarations)mv).getTypeExpression() == null ? null : J.Identifier.build(((J.VariableDeclarations)mv).getTypeExpression().getId(), ((J.VariableDeclarations)mv).getTypeExpression().getPrefix(), Markers.EMPTY, type.getClassName(), type));
            mv = ((J.VariableDeclarations)mv).withVariables(ListUtils.map(((J.VariableDeclarations)mv).getVariables(), var -> {
                JavaType.Class varType = TypeUtils.asClass(var.getType());
                if (varType != null && !varType.equals(type)) {
                    return var.withType(type).withName(var.getName().withType(type));
                }
                return var;
            }));
        }
        return mv;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeFieldType)) {
            return false;
        }
        ChangeFieldType other = (ChangeFieldType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaType.Class this$type = this.getType();
        JavaType.Class other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$targetType = this.getTargetType();
        String other$targetType = other.getTargetType();
        return !(this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeFieldType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JavaType.Class $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $targetType = this.getTargetType();
        result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
        return result;
    }

    public ChangeFieldType(JavaType.Class type, String targetType) {
        this.type = type;
        this.targetType = targetType;
    }

    public JavaType.Class getType() {
        return this.type;
    }

    public String getTargetType() {
        return this.targetType;
    }

    @NonNull
    public String toString() {
        return "ChangeFieldType(type=" + this.getType() + ", targetType=" + this.getTargetType() + ")";
    }
}

