/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.RefactorVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.InsertDeclaration;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class GenerateGetter {

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.ClassDecl scope;
        private final String fieldName;

        public Scoped(J.ClassDecl scope, String fieldName) {
            this.scope = scope;
            this.fieldName = fieldName;
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            if (classDecl.isScope(this.scope)) {
                J.VariableDecls field = classDecl.getFields().stream().filter(it -> it.getVars().get(0).getSimpleName().equals(this.fieldName)).findAny().orElse(null);
                if (field == null) {
                    return classDecl;
                }
                assert (field.getTypeExpr() != null);
                String simpleFieldName = field.getVars().get(0).getSimpleName();
                JavaType.Class classType = TypeUtils.asClass(classDecl.getType());
                if (classType != null) {
                    MethodMatcher getterMatcher = new MethodMatcher(classType.getFullyQualifiedName() + " get" + StringUtils.capitalize((String)simpleFieldName) + "()");
                    boolean getterAlreadyExists = classDecl.getMethods().stream().anyMatch(it -> getterMatcher.matches((J.MethodDecl)it, classDecl));
                    if (getterAlreadyExists) {
                        return classDecl;
                    }
                    boolean isMissingTargetField = classDecl.getFields().stream().noneMatch(arg_0 -> ((J.VariableDecls)field).isScope(arg_0));
                    if (isMissingTargetField) {
                        return classDecl;
                    }
                    J.VariableDecls.NamedVar fieldVar = field.getVars().get(0);
                    String fieldName = fieldVar.getSimpleName();
                    J.MethodDecl getMethod = this.treeBuilder.buildMethodDeclaration(classDecl, "public " + field.getTypeExpr().print().trim() + " get" + StringUtils.capitalize((String)fieldName) + "() {\n    return " + fieldName + ";\n}\n", field.getTypeAsClass());
                    this.andThen((RefactorVisitor)new InsertDeclaration.Scoped(classDecl, getMethod));
                }
            }
            return super.visitClassDecl(classDecl);
        }
    }
}

