/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.java.tree.J;

class ModifierComparator
implements Comparator<List<String>> {
    static final Comparator<List<String>> BY_STRING = new ModifierComparator();
    static final Comparator<List<J.Modifier>> BY_AST = (mods1, mods2) -> BY_STRING.compare(mods1.stream().map(mod -> mod.getClass().getSimpleName().toLowerCase()).collect(Collectors.toList()), mods2.stream().map(mod -> mod.getClass().getSimpleName().toLowerCase()).collect(Collectors.toList()));

    ModifierComparator() {
    }

    @Override
    public int compare(List<String> mods1, List<String> mods2) {
        boolean mods1Static = mods1.contains("static");
        boolean mods2Static = mods2.contains("static");
        if (mods1Static && !mods2Static) {
            return -1;
        }
        if (!mods1Static && mods2Static) {
            return 1;
        }
        boolean mods1Final = mods1.contains("final");
        boolean mods2Final = mods2.contains("final");
        if (mods1Final && !mods2Final) {
            return -1;
        }
        if (!mods1Final && mods2Final) {
            return 1;
        }
        int visibility = this.visibilityRank(mods1) - this.visibilityRank(mods2);
        if (visibility != 0) {
            return visibility;
        }
        int mods1Size = mods1.size();
        for (int i = 0; i < mods1Size; ++i) {
            if (mods2.size() <= i) {
                return -1;
            }
            int comp = mods1.get(i).compareTo(mods2.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    private int visibilityRank(List<String> modifiers) {
        if (modifiers.contains("public")) {
            return 0;
        }
        if (modifiers.contains("protected")) {
            return 1;
        }
        if (modifiers.contains("private")) {
            return 3;
        }
        return 2;
    }
}

